/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.xforceplus.general.cache.configuration.properties.CacheProperties;
import com.xforceplus.general.cache.configuration.properties.CaffeineInfo;
import com.xforceplus.general.cache.configuration.properties.RedissonProperties;
import com.xforceplus.general.cache.contants.ConfigConstants;
import com.xforceplus.general.cache.listener.CacheMessage;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.ListUtils;
import org.redisson.api.RBatch;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheAsync;
import org.redisson.api.RObject;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;

public class RedisCaffeineCache
extends AbstractValueAdaptingCache {
    private static final Logger log = LoggerFactory.getLogger(RedisCaffeineCache.class);
    private String cacheName;
    private RedissonClient redissonClient;
    private Cache<Object, Object> caffeineCache;
    private CacheProperties cacheProperties;
    private RedissonProperties redissonProperties;

    public RedisCaffeineCache(String cacheName, RedissonClient redissonClient, Cache<Object, Object> caffeineCache, CacheProperties cacheProperties, RedissonProperties redissonProperties) {
        super(cacheProperties.isAllowNullValues());
        this.cacheName = cacheName;
        this.redissonClient = redissonClient;
        this.caffeineCache = caffeineCache;
        this.cacheProperties = cacheProperties;
        this.redissonProperties = redissonProperties;
    }

    public String getName() {
        return this.cacheName;
    }

    public Object getNativeCache() {
        return this;
    }

    private String renameKey(Object cacheKey) {
        if (null == this.redissonProperties) {
            return String.format("%s:%s", ConfigConstants.ENV, cacheKey);
        }
        return String.format("%s:%s:%s", ConfigConstants.ENV, this.redissonProperties.getAppId(), cacheKey);
    }

    private boolean enableRedis() {
        return this.cacheProperties.isEnableRedis() && null != this.redissonClient;
    }

    protected Object lookup(Object key) {
        Object value = this.caffeineCache.getIfPresent(key);
        if (Objects.nonNull(value)) {
            log.info("get data from caffeine,key:{}", key);
            return value;
        }
        if (this.enableRedis() && Objects.nonNull(value = this.redissonClient.getMapCache(this.cacheName).get((Object)this.renameKey(key)))) {
            log.info("get data from redis");
            this.caffeineCache.put(key, value);
        }
        return value;
    }

    public void put(Object key, Object value) {
        if (!this.isAllowNullValues() && Objects.isNull(value)) {
            log.error("the value NULL will not be cached");
            return;
        }
        if (Objects.isNull(value)) {
            this.caffeineCache.put(key, this.toStoreValue(value));
            return;
        }
        this.saveRedisAndSend(key, value);
        this.caffeineCache.put(key, value);
    }

    private void saveRedisAndSend(Object key, Object value) {
        if (!this.enableRedis()) {
            log.info("redis cache enable status {} or redissonClient is empty", (Object)this.cacheProperties.isEnableRedis());
            return;
        }
        List<CaffeineInfo> specialCacheList = this.cacheProperties.getSpecialCache();
        CaffeineInfo caffeineInfo = ListUtils.emptyIfNull(specialCacheList).stream().filter(r -> this.cacheName.equals(r.getCacheName())).findFirst().orElse(this.cacheProperties.getDefaultCache());
        RMapCache mapCache = this.redissonClient.getMapCache(this.cacheName);
        boolean isExists = mapCache.isExists();
        if (!isExists) {
            RBatch batch = this.redissonClient.createBatch();
            RMapCacheAsync rMapCacheAsync = batch.getMapCache(this.cacheName);
            rMapCacheAsync.putAsync(key, value, caffeineInfo.getExpireAfterWriteSeconds(), TimeUnit.SECONDS);
            batch.execute();
        } else {
            mapCache.put(key, value, caffeineInfo.getExpireAfterWriteSeconds(), TimeUnit.SECONDS);
        }
        this.redissonClient.getTopic(this.renameKey("general:tool:cache:redis:caffeine:topic")).publish((Object)new CacheMessage(this.cacheName, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        ReentrantLock lock = null;
        try {
            lock = new ReentrantLock();
            lock.lock();
            Object obj = this.lookup(key);
            if (Objects.nonNull(obj)) {
                Object object = obj;
                return (T)object;
            }
            obj = valueLoader.call();
            this.put(key, obj);
            Object object = obj;
            return (T)object;
        }
        catch (Exception e) {
            log.error("get cache key", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        if (!this.isAllowNullValues() && Objects.isNull(value)) {
            log.error("the value NULL will not be cached");
            return null;
        }
        if (Objects.isNull(value)) {
            this.caffeineCache.put(key, this.toStoreValue(value));
            return null;
        }
        this.saveRedisAndSend(key, value);
        this.caffeineCache.put(key, value);
        return this.toValueWrapper(value);
    }

    public void evict(Object key) {
        if (this.enableRedis()) {
            RMapCache mapCache = this.redissonClient.getMapCache(this.cacheName);
            Optional.ofNullable(mapCache).ifPresent(r -> r.remove((Object)this.renameKey(key)));
            this.redissonClient.getTopic(this.renameKey("general:tool:cache:redis:caffeine:topic")).publish((Object)new CacheMessage(this.cacheName, key));
        }
        this.caffeineCache.invalidate(key);
    }

    public void clear() {
        if (this.enableRedis()) {
            RMapCache mapCache = this.redissonClient.getMapCache(this.cacheName);
            Optional.ofNullable(mapCache).ifPresent(RObject::delete);
            this.redissonClient.getTopic(this.renameKey("general:tool:cache:redis:caffeine:topic")).publish((Object)new CacheMessage(this.cacheName));
        }
        this.caffeineCache.invalidateAll();
    }
}

