/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.xforceplus.general.cache.RedisCaffeineCache;
import com.xforceplus.general.cache.configuration.properties.CacheProperties;
import com.xforceplus.general.cache.configuration.properties.CaffeineInfo;
import com.xforceplus.general.cache.configuration.properties.RedissonProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.ListUtils;
import org.redisson.api.RedissonClient;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class RedisCaffeineCacheManager
implements CacheManager {
    Map<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();
    private CacheProperties cacheProperties;
    private RedissonClient redissonClient;
    private RedissonProperties redissonProperties;

    public RedisCaffeineCacheManager(CacheProperties cacheProperties, RedissonClient redissonClient, RedissonProperties redissonProperties) {
        this.cacheProperties = cacheProperties;
        this.redissonClient = redissonClient;
        this.redissonProperties = redissonProperties;
    }

    public Cache getCache(String cacheName) {
        return this.cacheMap.computeIfAbsent(cacheName, key -> new RedisCaffeineCache((String)key, this.redissonClient, (com.github.benmanes.caffeine.cache.Cache<Object, Object>)this.createCaffeineCache((String)key), this.cacheProperties, this.redissonProperties));
    }

    public Collection<String> getCacheNames() {
        return this.cacheMap.keySet();
    }

    private com.github.benmanes.caffeine.cache.Cache createCaffeineCache(String cacheName) {
        Caffeine caffeineBuilder = Caffeine.newBuilder();
        List<CaffeineInfo> specialCacheList = this.cacheProperties.getSpecialCache();
        CaffeineInfo caffeineInfo = ListUtils.emptyIfNull(specialCacheList).stream().filter(r -> cacheName.equals(r.getCacheName())).findFirst().orElse(this.cacheProperties.getDefaultCache());
        caffeineBuilder.expireAfterWrite(caffeineInfo.getExpireAfterWriteSeconds(), TimeUnit.SECONDS);
        caffeineBuilder.initialCapacity(caffeineInfo.getInitialCapacity());
        caffeineBuilder.maximumSize((long)caffeineInfo.getMaximumSize());
        return caffeineBuilder.build();
    }
}

