/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.cache.configuration;

import com.xforceplus.general.cache.RedisCaffeineCacheManager;
import com.xforceplus.general.cache.configuration.properties.CacheProperties;
import com.xforceplus.general.cache.configuration.properties.RedissonProperties;
import com.xforceplus.general.cache.contants.ConfigConstants;
import com.xforceplus.general.cache.listener.CacheMessage;
import com.xforceplus.general.cache.listener.CacheMessageListener;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@EnableCaching
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheConfiguration
extends CachingConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(CacheConfiguration.class);

    @Primary
    @Bean
    public CacheManager redisCaffeineCacheManager(CacheProperties cacheProperties, @Autowired(required=false) RedissonClient redissonClient, @Autowired(required=false) RedissonProperties redissonProperties) {
        return new RedisCaffeineCacheManager(cacheProperties, redissonClient, redissonProperties);
    }

    @ConditionalOnProperty(prefix="xforce.gen-tool.redis", name={"enabled"}, havingValue="true")
    @Bean
    public RTopic saveSubscribe(RedisCaffeineCacheManager redisCaffeineCacheManager, RedissonClient redissonClient, RedissonProperties redissonProperties) {
        RTopic rTopic = redissonClient.getTopic(String.format("%s:%s:%s", ConfigConstants.ENV, redissonProperties.getAppId(), "general:tool:cache:redis:caffeine:topic"));
        CacheMessageListener messageListener = new CacheMessageListener(redisCaffeineCacheManager);
        rTopic.addListener(CacheMessage.class, (MessageListener)messageListener);
        return rTopic;
    }

    @Bean
    public CacheErrorHandler errorHandler() {
        CacheErrorHandler cacheErrorHandler = new CacheErrorHandler(){

            public void handleCacheGetError(RuntimeException e, Cache cache, Object key) {
                log.error("handleCacheGetError, cache:{}, key:{}", new Object[]{cache.getName(), key, e});
            }

            public void handleCachePutError(RuntimeException e, Cache cache, Object key, Object value) {
                log.error("handleCachePutError, cache:{}, key:{}", new Object[]{cache.getName(), key, e});
            }

            public void handleCacheEvictError(RuntimeException e, Cache cache, Object key) {
                log.error("handleCacheEvictError, cache:{}, key:{}", new Object[]{cache.getName(), key, e});
            }

            public void handleCacheClearError(RuntimeException e, Cache cache) {
                log.error("handleCacheClearError, cache:{}", (Object)cache.getName(), (Object)e);
            }
        };
        return cacheErrorHandler;
    }
}

