/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.cache.configuration;

import com.xforceplus.general.cache.RedisService;
import com.xforceplus.general.cache.configuration.properties.RedissonProperties;
import com.xforceplus.general.cache.impl.RedisServiceImpl;
import java.util.Arrays;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="xforce.gen-tool.redis", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedissonConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedissonConfiguration.class);
    @Resource
    private RedissonProperties redissonProperties;

    @Bean
    public RedisService redisService(RedissonProperties redissonProperties, RedissonClient redissonClient) {
        return new RedisServiceImpl(redissonProperties, redissonClient);
    }

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        if (StringUtils.isNotBlank((CharSequence)this.redissonProperties.getHost())) {
            String address = String.format("redis://%s:%s", this.redissonProperties.getHost(), this.redissonProperties.getPort());
            SingleServerConfig serverConfig = (SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(address).setDatabase(this.redissonProperties.getDatabase().intValue()).setConnectionPoolSize(this.redissonProperties.getConnectionPoolSize().intValue()).setConnectionMinimumIdleSize(this.redissonProperties.getConnectionMinimumIdleSize().intValue()).setConnectTimeout(this.redissonProperties.getTimeout().intValue())).setTimeout(this.redissonProperties.getTimeout().intValue());
            if (StringUtils.isNotBlank((CharSequence)this.redissonProperties.getPassword())) {
                serverConfig.setPassword(this.redissonProperties.getPassword());
            }
        } else {
            if (null == this.redissonProperties.getSentinelNodes()) {
                throw new RuntimeException("You need to config the sentinelNodes property!");
            }
            SentinelServersConfig serversConfig = (SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(this.redissonProperties.getSentinelMaster()).setMasterConnectionPoolSize(this.redissonProperties.getConnectionPoolSize().intValue())).setMasterConnectionMinimumIdleSize(this.redissonProperties.getConnectionMinimumIdleSize().intValue())).setSlaveConnectionPoolSize(this.redissonProperties.getConnectionPoolSize().intValue())).setSlaveConnectionMinimumIdleSize(this.redissonProperties.getConnectionMinimumIdleSize().intValue())).setConnectTimeout(this.redissonProperties.getTimeout().intValue())).setTimeout(this.redissonProperties.getTimeout().intValue());
            Arrays.stream(this.redissonProperties.getSentinelNodes().split(",")).forEach(host -> serversConfig.addSentinelAddress(new String[]{"redis://" + host.trim()}));
            if (StringUtils.isNotBlank((CharSequence)this.redissonProperties.getPassword())) {
                serversConfig.setPassword(this.redissonProperties.getPassword());
            }
        }
        return Redisson.create((Config)config);
    }
}

