/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.cache.configuration.properties;

import com.xforceplus.general.cache.configuration.properties.CaffeineInfo;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="xforce.gen-tool.cache")
public class CacheProperties {
    public boolean enable;
    public static final String SYSTEM_ID = UUID.randomUUID().toString();
    private boolean allowNullValues = true;
    private CaffeineInfo defaultCache = CaffeineInfo.builder().initialCapacity(5).maximumSize(100).expireAfterWriteSeconds(TimeUnit.SECONDS.toSeconds(300L)).build();
    private List<CaffeineInfo> specialCache;
    private boolean enableRedis;

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public CaffeineInfo getDefaultCache() {
        return this.defaultCache;
    }

    public List<CaffeineInfo> getSpecialCache() {
        return this.specialCache;
    }

    public boolean isEnableRedis() {
        return this.enableRedis;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public void setDefaultCache(CaffeineInfo defaultCache) {
        this.defaultCache = defaultCache;
    }

    public void setSpecialCache(List<CaffeineInfo> specialCache) {
        this.specialCache = specialCache;
    }

    public void setEnableRedis(boolean enableRedis) {
        this.enableRedis = enableRedis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheProperties)) {
            return false;
        }
        CacheProperties other = (CacheProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isAllowNullValues() != other.isAllowNullValues()) {
            return false;
        }
        CaffeineInfo this$defaultCache = this.getDefaultCache();
        CaffeineInfo other$defaultCache = other.getDefaultCache();
        if (this$defaultCache == null ? other$defaultCache != null : !((Object)this$defaultCache).equals(other$defaultCache)) {
            return false;
        }
        List<CaffeineInfo> this$specialCache = this.getSpecialCache();
        List<CaffeineInfo> other$specialCache = other.getSpecialCache();
        if (this$specialCache == null ? other$specialCache != null : !((Object)this$specialCache).equals(other$specialCache)) {
            return false;
        }
        return this.isEnableRedis() == other.isEnableRedis();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isAllowNullValues() ? 79 : 97);
        CaffeineInfo $defaultCache = this.getDefaultCache();
        result = result * 59 + ($defaultCache == null ? 43 : ((Object)$defaultCache).hashCode());
        List<CaffeineInfo> $specialCache = this.getSpecialCache();
        result = result * 59 + ($specialCache == null ? 43 : ((Object)$specialCache).hashCode());
        result = result * 59 + (this.isEnableRedis() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CacheProperties(enable=" + this.isEnable() + ", allowNullValues=" + this.isAllowNullValues() + ", defaultCache=" + this.getDefaultCache() + ", specialCache=" + this.getSpecialCache() + ", enableRedis=" + this.isEnableRedis() + ")";
    }
}

