/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.cache.listener;

import com.xforceplus.general.cache.RedisCaffeineCache;
import com.xforceplus.general.cache.RedisCaffeineCacheManager;
import com.xforceplus.general.cache.configuration.properties.CacheProperties;
import com.xforceplus.general.cache.listener.CacheMessage;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CacheMessageListener
implements MessageListener<CacheMessage> {
    private static final Logger log = LoggerFactory.getLogger(CacheMessageListener.class);
    private RedisCaffeineCacheManager redisCaffeineCacheManager;

    public CacheMessageListener(RedisCaffeineCacheManager redisCaffeineCacheManager) {
        this.redisCaffeineCacheManager = redisCaffeineCacheManager;
    }

    public void onMessage(CharSequence charSequence, CacheMessage cacheMessage) {
        log.info("onMessage # receive a redis message, channel: " + charSequence);
        try {
            if (!CacheProperties.SYSTEM_ID.equals(cacheMessage.getSystemId())) {
                log.info("onMessage # receive native message {}, not handle", (Object)cacheMessage.getSystemId(), cacheMessage.getCacheKey());
                return;
            }
            RedisCaffeineCache cache = (RedisCaffeineCache)this.redisCaffeineCacheManager.getCache(cacheMessage.getCacheName());
            if (StringUtils.isEmpty((Object)cacheMessage.getCacheKey())) {
                cache.clear();
                log.info("onMessage # clear local cache {}", (Object)cacheMessage.getCacheName());
                return;
            }
            cache.evict(cacheMessage.getCacheKey());
            log.info("onMessage # evict local cache {}, the key is {}", (Object)cacheMessage.getCacheName(), cacheMessage.getCacheKey());
        }
        catch (Exception e) {
            log.error("onMessage error: # " + e.getMessage(), (Throwable)e);
        }
    }
}

