/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.context.extention;

import com.xforceplus.general.context.extention.Holder;
import com.xforceplus.general.context.extention.LoadingStrategy;
import com.xforceplus.general.context.extention.SPI;
import io.vavr.Tuple2;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(ExtensionLoader.class);
    private final Class<?> type;
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\s*[,]+\\s*");
    private static final ConcurrentMap<Class<?>, ExtensionLoader<?>> EXTENSION_LOADERS = new ConcurrentHashMap(64);
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap(64);
    private static volatile LoadingStrategy[] strategies = ExtensionLoader.loadLoadingStrategies();
    private String cachedDefaultName;
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();

    private ExtensionLoader(Class<?> type) {
        this.type = type;
    }

    public Set<String> getSupportedExtensions() {
        Map<String, Class<?>> classes = this.getExtensionClasses();
        return Collections.unmodifiableSet(new TreeSet<String>(classes.keySet()));
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an interface!");
        }
        if (!ExtensionLoader.withExtensionAnnotation(type)) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an extension, because it is NOT annotated with @" + SPI.class.getSimpleName() + "!");
        }
        ExtensionLoader loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        if (loader == null) {
            EXTENSION_LOADERS.putIfAbsent(type, new ExtensionLoader<T>(type));
            loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        }
        return loader;
    }

    private static <T> boolean withExtensionAnnotation(Class<T> type) {
        return type.isAnnotationPresent(SPI.class);
    }

    public T getExtension(String name) {
        return this.getExtension(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name, Tuple2<Class<?>[], Object[]> parameters) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Holder<Object> holder = this.getOrCreateHolder(name);
        Object instance = holder.get();
        if (instance == null) {
            Holder<Object> holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name, parameters);
                    holder.set(instance);
                }
            }
        }
        return (T)instance;
    }

    private T createExtension(String name, Tuple2<Class<?>[], Object[]> parameters) {
        return this.createExtensionWithTypes(name, parameters);
    }

    private T createExtensionWithTypes(String name, Tuple2<Class<?>[], Object[]> parameters) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            return null;
        }
        try {
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                Object createObj;
                if (null == parameters || ArrayUtils.isEmpty((Object[])((Object[])parameters._1))) {
                    createObj = clazz.newInstance();
                } else {
                    Constructor<?> constructor = clazz.getConstructor((Class[])parameters._1);
                    createObj = constructor.newInstance((Object[])parameters._2);
                }
                EXTENSION_INSTANCES.putIfAbsent(clazz, createObj);
                instance = EXTENSION_INSTANCES.get(clazz);
            }
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance (name: " + name + ", class: " + this.type + ") couldn't be instantiated: " + t.getMessage(), t);
        }
    }

    private Holder<Object> getOrCreateHolder(String name) {
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            holder = (Holder)this.cachedInstances.get(name);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = this.cachedClasses.get();
        if (MapUtils.isEmpty(classes)) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.get();
                if (classes == null) {
                    classes = this.loadExtensionClasses();
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    private static LoadingStrategy[] loadLoadingStrategies() {
        return (LoadingStrategy[])StreamSupport.stream(ServiceLoader.load(LoadingStrategy.class).spliterator(), false).sorted().toArray(LoadingStrategy[]::new);
    }

    private Map<String, Class<?>> loadExtensionClasses() {
        this.cacheDefaultExtensionName();
        HashMap extensionClasses = new HashMap();
        for (LoadingStrategy strategy : strategies) {
            this.loadDirectory(extensionClasses, strategy.directory(), this.type.getName());
        }
        return extensionClasses;
    }

    public T getDefaultExtension() {
        this.getExtensionClasses();
        if (StringUtils.isEmpty((CharSequence)this.cachedDefaultName)) {
            return null;
        }
        return this.getExtension(this.cachedDefaultName);
    }

    public T getDefaultExtension(Tuple2<Class<?>[], Object[]> parameters) {
        this.getExtensionClasses();
        if (StringUtils.isEmpty((CharSequence)this.cachedDefaultName)) {
            return null;
        }
        return this.getExtension(this.cachedDefaultName, parameters);
    }

    private void cacheDefaultExtensionName() {
        SPI defaultAnnotation = this.type.getAnnotation(SPI.class);
        if (defaultAnnotation == null) {
            return;
        }
        String value = defaultAnnotation.value();
        if ((value = value.trim()).length() > 0) {
            Object[] names = NAME_SEPARATOR.split(value);
            if (names.length > 1) {
                throw new IllegalStateException("More than 1 default extension name on extension " + this.type.getName() + ": " + Arrays.toString(names));
            }
            if (names.length == 1) {
                this.cachedDefaultName = names[0];
            }
        }
    }

    private void loadDirectory(Map<String, Class<?>> extensionClasses, String dir, String type) {
        String fileName = dir + type;
        try {
            Enumeration<URL> urls;
            ClassLoader classLoader = ExtensionLoader.findClassLoader();
            Enumeration<URL> enumeration = urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    this.loadResource(extensionClasses, classLoader, urls.nextElement(), new String[0]);
                }
            }
        }
        catch (Throwable t) {
            log.error("Exception occurred when loading extension class (interface: {}, description file: {})", new Object[]{extensionClasses, fileName, t});
        }
    }

    private void loadResource(Map<String, Class<?>> serviceClass, ClassLoader classLoader, URL resourceURL, String ... excludedPackages) {
        block20: {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            int ci = line.indexOf(35);
                            if (ci >= 0) {
                                line = line.substring(0, ci);
                            }
                            if ((line = line.trim()).length() <= 0) continue;
                            try {
                                String name = null;
                                int i = line.indexOf(61);
                                if (i > 0) {
                                    name = line.substring(0, i).trim();
                                    line = line.substring(i + 1).trim();
                                }
                                if (line.length() <= 0 || this.isExcluded(line, excludedPackages)) continue block13;
                                this.loadClass(serviceClass, classLoader, resourceURL, name, line);
                                continue block13;
                            }
                            catch (Exception e) {
                                log.error("Failed to load extension class (class line: " + line + ") in " + resourceURL + ", cause: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (Throwable t) {
                log.error("Exception occurred when loading extension class (class file: " + resourceURL + ") in " + resourceURL, t);
            }
        }
    }

    private boolean isExcluded(String className, String ... excludedPackages) {
        if (excludedPackages != null) {
            for (String excludePackage : excludedPackages) {
                if (!className.startsWith(excludePackage + ".")) continue;
                return true;
            }
        }
        return false;
    }

    private static ClassLoader findClassLoader() {
        return ExtensionLoader.class.getClassLoader();
    }

    private void loadClass(Map<String, Class<?>> serviceClass, ClassLoader classLoader, URL url, String name, String line) throws ClassNotFoundException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalStateException("No such extension name for the class " + name + " in the config " + url);
        }
        Class<?> o = serviceClass.get(name);
        if (o == null) {
            serviceClass.put(name, Class.forName(line, true, classLoader));
        } else {
            log.warn("Duplicate extension name {} line {} ", (Object)name, (Object)line);
        }
    }
}

