package com.xforceplus.general.starter.errorcode;

import com.xforceplus.general.starter.ApplicationProvider;
import lombok.Getter;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/5/5 15:00
 */
@Getter
public class ErrorCodeContext {

    private static final ErrorCodeContext INSTANCE = new ErrorCodeContext();

    private static ApplicationProvider defaultApplicationProvider = new ApplicationProvider();

    private String codeFieldName;

    private String messageFieldName;

    private Class<? extends ErrorCodeConfigRepository> errorCodeConfigRepository;


    private boolean initialized = false;

    public void init(String codeFieldName, String messageFieldName, Class<? extends ErrorCodeConfigRepository> errorCodeConfigRepository) {
        this.codeFieldName = codeFieldName;
        this.messageFieldName = messageFieldName;
        this.errorCodeConfigRepository = errorCodeConfigRepository;

        defaultApplicationProvider.initialize();

        initialized = true;
    }

    public static ErrorCodeContext getInstance() {
        return INSTANCE;
    }

}
