package com.xforceplus.general.starter.errorcode;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/5/5 14:54
 */
public class ErrorCodeSelector implements ImportSelector {

    @Override
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Map<String, Object> allAnnotationAttributes = importingClassMetadata.getAnnotationAttributes(EnableTenantErrorCoder.class.getName());
        Class errorCodeConfigRepository = (Class) allAnnotationAttributes.get("repository");

        String codeFieldName = MapUtils.getString(allAnnotationAttributes, "codeFieldName");
        String messageFieldName = MapUtils.getString(allAnnotationAttributes, "messageFieldName");

        ErrorCodeContext.getInstance().init(codeFieldName, messageFieldName, errorCodeConfigRepository);

        List<String> imports = Lists.newArrayList(ErrorCodeConfiguration.class.getName(), RemoteErrorCodeConfigRepository.class.getName(), ApolloErrorCodeConfigRepository.class.getName(),
            ErrorCodeInterceptor.class.getName());

        if (errorCodeConfigRepository != null) {
            imports.add(errorCodeConfigRepository.getName());
        }

        return imports.toArray(new String[imports.size()]);
    }


}
