package com.xforceplus.general.starter;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/5/11 15:47
 */
public class ApplicationProvider {

    private static final Logger logger = LoggerFactory.getLogger(ApplicationProvider.class);
    private Properties m_appProperties = new Properties();
    private String m_appId;

    public ApplicationProvider() {
    }

    public void initialize() {
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("/META-INF/app.properties".substring(1));
            if (in == null) {
                in = ApplicationProvider.class.getResourceAsStream("/META-INF/app.properties");
            }

            this.initialize(in);
        } catch (Throwable var2) {
            logger.error("Initialize DefaultApplicationProvider failed.", var2);
        }

    }

    public void initialize(InputStream in) {
        try {
            if (in != null) {
                try {
                    this.m_appProperties.load(new InputStreamReader(in, StandardCharsets.UTF_8));
                } finally {
                    in.close();
                }
            }

            this.initAppId();
        } catch (Throwable var6) {
            logger.error("Initialize DefaultApplicationProvider failed.", var6);
        }

    }

    public String getAppId() {
        return this.m_appId;
    }

    public String getProperty(String name, String defaultValue) {
        String val;
        if ("app.id".equals(name)) {
            val = this.getAppId();
            return val == null ? defaultValue : val;
        } else {
            val = this.m_appProperties.getProperty(name, defaultValue);
            return val == null ? defaultValue : val;
        }
    }


    private void initAppId() {
        this.m_appId = System.getProperty("app.id");
        if (StringUtils.isNotBlank(this.m_appId)) {
            this.m_appId = this.m_appId.trim();
            logger.info("App ID is set to {} by app.id property from System Property", this.m_appId);
        } else {
            this.m_appId = this.m_appProperties.getProperty("app.id");
            if (StringUtils.isNotBlank(this.m_appId)) {
                this.m_appId = this.m_appId.trim();
                logger.info("App ID is set to {} by app.id property from {}", this.m_appId, "/META-INF/app.properties");
            } else {
                this.m_appId = null;
                logger.warn("app.id is not available from System Property and {}. It is set to null", "/META-INF/app.properties");
            }
        }
    }

    @Override
    public String toString() {
        return "appId [" + this.getAppId() + "] properties: " + this.m_appProperties + " (ApplicationProvider)";
    }

}
