package com.xforceplus.general.starter.errorcode;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;

/**
 * @author zhuxingsheng@gmail.com
 * @description: remote get error code config
 * @date 2022/5/5 14:34
 */
@Slf4j
public class RemoteErrorCodeConfigRepository implements ErrorCodeConfigRepository {

    LoadingCache<String, ErrorCode> cache = CacheBuilder.newBuilder()
        // 缓存刷新时间
        .refreshAfterWrite(10, TimeUnit.MINUTES)
        // 设置缓存个数
        .maximumSize(500)
        .build(new CacheLoader<String, ErrorCode>() {
            @Override
            // 当本地缓存命没有中时，调用load方法获取结果并将结果缓存
            public ErrorCode load(String appKey) {
                return getEntryFromDB(appKey);
            }

            // 数据库进行查询
            private ErrorCode getEntryFromDB(String name) {
                log.info("load entry info from db!entry:{}", name);
                return null;
            }
        });

    @Override
    public Optional<ErrorCode> getErrorCode(HttpMethod httpMethod, String requestPath, String tenantCode, String code) {
        return Optional.empty();
    }

}
