/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.executor.thread.executor;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.xforceplus.general.executor.thread.MyThreadPoolExecutor;
import com.xforceplus.general.executor.thread.configuration.ThreadPoolProperties;
import com.xforceplus.general.executor.thread.factory.ThreadPoolFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class GeneralThreadPoolTaskExecutor
implements MyThreadPoolExecutor {
    private ThreadPoolProperties globalPoolProperties;
    private ThreadPoolTaskExecutor executor;

    public GeneralThreadPoolTaskExecutor(ThreadPoolProperties globalPoolProperties) {
        this.globalPoolProperties = globalPoolProperties;
        this.executor = ThreadPoolFactory.createThreadPoolTaskExecutor(this.getThreadPrefix(), globalPoolProperties.getCorePoolSize(), globalPoolProperties.getMaxPoolSize(), globalPoolProperties.getKeepAliveSecond(), globalPoolProperties.getBlockQueueSize());
    }

    @Override
    public Executor executor() {
        return TtlExecutors.getTtlExecutor((Executor)this.executor.getThreadPoolExecutor());
    }

    @Override
    public ThreadPoolExecutor concreteExecutor() {
        return this.executor.getThreadPoolExecutor();
    }

    @Override
    public int getKeepAliveSecond() {
        return this.globalPoolProperties.getKeepAliveSecond();
    }

    @Override
    public int getCorePoolSize() {
        return this.globalPoolProperties.getCorePoolSize();
    }

    @Override
    public int getMaxPoolSize() {
        return this.globalPoolProperties.getMaxPoolSize();
    }

    @Override
    public int getBlockQueueSize() {
        return this.globalPoolProperties.getBlockQueueSize();
    }

    @Override
    public String getThreadPrefix() {
        return "global";
    }
}

