/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.executor.thread.factory;

import com.xforceplus.general.executor.thread.factory.NamedThreadFactory;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ThreadPoolFactory {
    public static ThreadPoolTaskExecutor createThreadPoolTaskExecutor(String prefix, int corePoolSize, int maximumPoolSize, int keepAliveSecond, int blockQueueSize) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        if (corePoolSize > 0) {
            executor.setCorePoolSize(corePoolSize);
        }
        if (maximumPoolSize > 0) {
            executor.setMaxPoolSize(maximumPoolSize);
        }
        if (keepAliveSecond > 0) {
            executor.setKeepAliveSeconds(keepAliveSecond);
        }
        if (blockQueueSize > 0) {
            executor.setQueueCapacity(blockQueueSize);
        }
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setThreadFactory((ThreadFactory)new NamedThreadFactory(prefix, false));
        executor.initialize();
        return executor;
    }

    public static ScheduledThreadPoolExecutor createScheduledThreadPoolExecutor(String prefix, int corePoolSize, int maximumPoolSize, int keepAliveSecond) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(corePoolSize, new NamedThreadFactory(prefix, false));
        if (corePoolSize > 0) {
            executor.setCorePoolSize(corePoolSize);
        }
        if (maximumPoolSize > 0) {
            executor.setMaximumPoolSize(maximumPoolSize);
        }
        if (keepAliveSecond > 0) {
            executor.setKeepAliveTime(keepAliveSecond, TimeUnit.SECONDS);
        }
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }
}

