/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.executor.thread.support;

import com.xforceplus.general.executor.thread.MyThreadPoolExecutor;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;

@EnableScheduling
public class AsyncThreadPoolChecker
implements SchedulingConfigurer,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AsyncThreadPoolChecker.class);
    @Value(value="${spring.schedule.thread.check.cron:0 0/10 * * * ?}")
    private String cron;
    private ApplicationContext applicationContext;

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addTriggerTask(this::checkAsyncThreadPool, triggerContext -> new CronTrigger(this.cron).nextExecutionTime(triggerContext));
    }

    public void checkAsyncThreadPool() {
        Map executorMap = this.applicationContext.getBeansOfType(MyThreadPoolExecutor.class);
        executorMap.forEach((beanName, myPool) -> this.printInfo(myPool.getThreadPrefix(), (MyThreadPoolExecutor)myPool));
    }

    private void printInfo(String name, MyThreadPoolExecutor myThreadPoolExecutor) {
        ThreadPoolExecutor threadPoolExecutor = myThreadPoolExecutor.concreteExecutor();
        long queueSize = threadPoolExecutor.getQueue().size();
        String msg = String.format("\u7ebf\u7a0b\u6c60\u5065\u5eb7\u68c0\u67e5 \u540d\u79f0: %s \u6c60\u5927\u5c0f: %d (\u5f53\u524d\u6d3b\u52a8\u7ebf\u7a0b\u6570: %d, \u6838\u5fc3\u7ebf\u7a0b\u7684\u6570\u91cf: %d, \u5141\u8bb8\u7684\u6700\u5927\u7ebf\u7a0b\u6570: %d, \u66fe\u7ecf\u521b\u5efa\u8fc7\u7684\u6700\u5927\u7ebf\u7a0b\u6570: %d), \u9700\u8981\u6267\u884c\u7684\u603b\u4efb\u52a1\u6570: %d (\u5b8c\u6210\u4efb\u52a1\u6570: %d)(\u961f\u5217\u603b\u5927\u5c0f: %d \u6392\u961f\u4efb\u52a1\u6570: %d) Executor status:(isShutdown:%s, isTerminated:%s, isTerminating:%s)", name, threadPoolExecutor.getPoolSize(), threadPoolExecutor.getActiveCount(), threadPoolExecutor.getCorePoolSize(), threadPoolExecutor.getMaximumPoolSize(), threadPoolExecutor.getLargestPoolSize(), threadPoolExecutor.getTaskCount(), threadPoolExecutor.getCompletedTaskCount(), myThreadPoolExecutor.getBlockQueueSize(), queueSize, threadPoolExecutor.isShutdown(), threadPoolExecutor.isTerminated(), threadPoolExecutor.isTerminating());
        long warnQueueSize = myThreadPoolExecutor.getBlockQueueSize() / 4;
        if (queueSize > warnQueueSize) {
            log.warn("\u8b66\u544a\uff01\u7ebf\u7a0b\u6c60: {}} \u6392\u961f\u7ebf\u7a0b\u6570\u8d85\u8fc7\u603b\u961f\u5217\u5927\u5c0f\u56db\u5206\u4e4b\u4e00!! {}", (Object)name, (Object)msg);
        } else {
            log.info(msg);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

