/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.executor.thread.executor;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.xforceplus.general.executor.thread.MyThreadPoolExecutor;
import com.xforceplus.general.executor.thread.configuration.ThreadPoolProperties;
import com.xforceplus.general.executor.thread.factory.ThreadPoolFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleThreadPoolExecutor
implements MyThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(ScheduleThreadPoolExecutor.class);
    private ThreadPoolProperties schedulePoolProperties;
    private ScheduledThreadPoolExecutor executor;

    public ScheduleThreadPoolExecutor(ThreadPoolProperties schedulePoolProperties) {
        this.schedulePoolProperties = schedulePoolProperties;
        this.executor = ThreadPoolFactory.createScheduledThreadPoolExecutor(this.getThreadPrefix(), schedulePoolProperties.getCorePoolSize(), schedulePoolProperties.getMaxPoolSize(), schedulePoolProperties.getKeepAliveSecond());
    }

    @Override
    public Executor executor() {
        return TtlExecutors.getTtlExecutor((Executor)this.executor);
    }

    @Override
    public ThreadPoolExecutor concreteExecutor() {
        return this.executor;
    }

    @Override
    public int getKeepAliveSecond() {
        return this.schedulePoolProperties.getKeepAliveSecond();
    }

    @Override
    public int getCorePoolSize() {
        return this.schedulePoolProperties.getCorePoolSize();
    }

    @Override
    public int getMaxPoolSize() {
        return this.schedulePoolProperties.getMaxPoolSize();
    }

    @Override
    public int getBlockQueueSize() {
        return this.schedulePoolProperties.getBlockQueueSize();
    }

    @Override
    public String getThreadPrefix() {
        return "schedule";
    }
}

