/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.message;

import com.xforceplus.general.message.MessageService;
import com.xforceplus.general.message.enums.SendType;
import com.xforceplus.general.message.model.CommonResponse;
import com.xforceplus.general.message.model.MessageContext;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MessageFactory {
    @Autowired
    private ApplicationContext applicationContext;

    public CommonResponse send(SendType sendType, MessageContext messageContext) {
        Map messageServiceMap = this.applicationContext.getBeansOfType(MessageService.class);
        if (MapUtils.isEmpty((Map)messageServiceMap)) {
            return CommonResponse.failed("No suitable MessageService");
        }
        Optional<MessageService> serviceOptional = messageServiceMap.values().stream().filter(r -> r.isAccept(sendType)).findFirst();
        if (serviceOptional.isPresent()) {
            if (CollectionUtils.isEmpty(messageContext.getReceiverList())) {
                return CommonResponse.failed("receiver is not empty");
            }
            return serviceOptional.get().send(messageContext);
        }
        return CommonResponse.failed(String.format("No suitable MessageService For %s", new Object[]{sendType}));
    }
}

