/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.message.configuration;

import com.xforceplus.general.message.MessageFactory;
import com.xforceplus.general.message.MessageProvider;
import com.xforceplus.general.message.MessageService;
import com.xforceplus.general.message.impl.DefaultMessageProviderImpl;
import com.xforceplus.general.message.impl.EmailMessageServiceImpl;
import com.xforceplus.general.message.impl.SmsMessageServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

public class MessageConfiguration {
    @Value(value="${xforce.tenant.security.domain:}")
    private String gateUrl;
    @Value(value="${xforce.tenant.security.appid:}")
    private Long appId;

    @Bean
    public MessageFactory messageFactory() {
        return new MessageFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageProvider.class})
    public MessageProvider messageProvider() {
        return new DefaultMessageProviderImpl();
    }

    @Bean
    public MessageService emailMessageService(MessageProvider messageProvider) {
        return new EmailMessageServiceImpl(messageProvider, this.gateUrl, this.appId);
    }

    @Bean
    public MessageService smsMessageService(MessageProvider messageProvider) {
        return new SmsMessageServiceImpl(messageProvider, this.gateUrl, this.appId);
    }
}

