/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.message.impl;

import com.xforceplus.general.message.MessageProvider;
import com.xforceplus.general.message.MessageService;
import com.xforceplus.general.message.enums.SendType;
import com.xforceplus.general.message.model.CommonResponse;
import com.xforceplus.general.message.model.EmailRequest;
import com.xforceplus.general.message.model.MessageContext;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class EmailMessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(EmailMessageServiceImpl.class);
    private final String requestUrl = "%s/api/%s/message/v1/email";
    private MessageProvider messageProvider;
    private String gateUrl;
    private Long appId;

    public EmailMessageServiceImpl(MessageProvider messageProvider, String gateUrl, Long appId) {
        this.messageProvider = messageProvider;
        this.gateUrl = gateUrl;
        this.appId = appId;
    }

    @Override
    public CommonResponse send(MessageContext messageContext) {
        try {
            String emailApi = String.format("%s/api/%s/message/v1/email", this.gateUrl, messageContext.getTenantId());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("x-app-token", this.messageProvider.getToken());
            EmailRequest.EmailRequestBuilder requestBuilder = EmailRequest.builder().tenantId(messageContext.getTenantId()).subject(messageContext.getSubject()).content(messageContext.getContent()).attachments(messageContext.getAttachments()).templateCode(messageContext.getTemplateCode());
            Optional.ofNullable(this.appId).ifPresent(requestBuilder::appId);
            Optional.ofNullable(messageContext.getReceiverList()).ifPresent(receivers -> requestBuilder.receiverList(receivers.stream().map(item -> {
                EmailRequest.Receiver receiver = new EmailRequest.Receiver();
                receiver.setReceiver((String)item);
                return receiver;
            }).collect(Collectors.toList())));
            HttpEntity request = new HttpEntity((Object)requestBuilder.build(), (MultiValueMap)headers);
            ResponseEntity response = this.messageProvider.getRestTemplate().exchange(emailApi, HttpMethod.POST, request, Map.class, new Object[0]);
            return Optional.ofNullable(response).map(r -> CommonResponse.from(MapUtils.getInteger((Map)((Map)r.getBody()), (Object)"code", (Integer)CommonResponse.Fail), MapUtils.getString((Map)((Map)r.getBody()), (Object)"desc"))).orElse(CommonResponse.failed("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u7a7a"));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25", (Throwable)e);
            return CommonResponse.failed(String.format("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25:%s", e.getMessage()));
        }
    }

    @Override
    public boolean isAccept(SendType sendType) {
        return SendType.Email.equals((Object)sendType);
    }
}

