/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.message.impl;

import com.xforceplus.general.message.MessageProvider;
import com.xforceplus.general.message.MessageService;
import com.xforceplus.general.message.enums.SendType;
import com.xforceplus.general.message.model.CommonResponse;
import com.xforceplus.general.message.model.ErrorMessage;
import com.xforceplus.general.message.model.MessageContext;
import com.xforceplus.general.message.model.SmsRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class SmsMessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(SmsMessageServiceImpl.class);
    private final String requestUrl = "%s/api/%s/message/v1/sms";
    private MessageProvider messageProvider;
    private String gateUrl;
    private Long appId;

    public SmsMessageServiceImpl(MessageProvider messageProvider, String gateUrl, Long appId) {
        this.messageProvider = messageProvider;
        this.gateUrl = gateUrl;
        this.appId = appId;
    }

    @Override
    public CommonResponse send(MessageContext messageContext) {
        try {
            String smsApi = String.format("%s/api/%s/message/v1/sms", this.gateUrl, messageContext.getTenantId());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("x-app-token", this.messageProvider.getToken());
            SmsRequest.SmsRequestBuilder requestBuilder = SmsRequest.builder().tenantId(messageContext.getTenantId()).content(messageContext.getContent());
            Optional.ofNullable(this.appId).ifPresent(requestBuilder::appId);
            List errorList = messageContext.getReceiverList().stream().map(receiver -> this.execute(smsApi, (String)receiver, requestBuilder, headers)).filter(Objects::nonNull).collect(Collectors.toList());
            return Optional.ofNullable(errorList).map(r -> {
                if (errorList.size() == messageContext.getReceiverList().size()) {
                    return CommonResponse.from(CommonResponse.Fail, "\u53d1\u9001\u77ed\u4fe1\u5931\u8d25", errorList);
                }
                return CommonResponse.ok("\u53d1\u9001\u77ed\u4fe1\u90e8\u5206\u5931\u8d25", errorList);
            }).orElse(CommonResponse.ok("\u53d1\u9001\u77ed\u4fe1\u6210\u529f"));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25", (Throwable)e);
            return CommonResponse.failed(e.getMessage());
        }
    }

    private ErrorMessage execute(String smsApi, String receiver, SmsRequest.SmsRequestBuilder requestBuilder, HttpHeaders headers) {
        requestBuilder.mobile(receiver);
        HttpEntity request = new HttpEntity((Object)requestBuilder.build(), (MultiValueMap)headers);
        ResponseEntity response = this.messageProvider.getRestTemplate().exchange(smsApi, HttpMethod.POST, request, Map.class, new Object[0]);
        if (null == response) {
            return ErrorMessage.builder().receiver(receiver).message("\u8fd4\u56de\u7ed3\u679c\u7a7a").build();
        }
        Map bodyMap = (Map)response.getBody();
        Integer code = MapUtils.getInteger((Map)bodyMap, (Object)"code");
        String desc = MapUtils.getString((Map)bodyMap, (Object)"desc");
        if (null == code || CommonResponse.Fail.equals(code)) {
            return ErrorMessage.builder().receiver(receiver).message(desc).build();
        }
        return null;
    }

    @Override
    public boolean isAccept(SendType sendType) {
        return SendType.Sms.equals((Object)sendType);
    }
}

