package com.xforceplus.general.sqs.configuration;

import com.xforceplus.general.common.ApplicationContextHolder;
import com.xforceplus.general.sqs.init.SqsStartAfterAppReady;
import lombok.Data;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/5/16 22:46
 */
@Data
@Configuration
public class ObservableSqsAutoConfiguration {

    @Bean
    public SqsStartAfterAppReady sqsReady() {
        return new SqsStartAfterAppReady();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationContextHolder generalApplicationContextHolder() {
        return new ApplicationContextHolder();
    }

}
