package com.xforceplus.general.sqs.event;

import lombok.Getter;
import org.springframework.context.ApplicationEvent;

/**
 * @author zhuxingsheng@gmail.com
 * @description: SQS的namespace准备就绪事件，表明消费队列的线程池已经就绪
 * @date 2023/5/28 23:47
 */
@Getter
public class NamespaceReadyEvent extends ApplicationEvent {

    public static final String NAMESPACE_ALL = "all-namespace";

    private final String namespace;

    public NamespaceReadyEvent() {
        super(NAMESPACE_ALL);
        this.namespace = NAMESPACE_ALL;
    }

    /**
     * Create a new ApplicationEvent.
     *
     * @param namespace the object on which the event initially occurred (never {@code null})
     */
    public NamespaceReadyEvent(final String namespace) {
        super(namespace);
        this.namespace = namespace;
    }

}
