package com.xforceplus.general.sqs.init;

import com.xforceplus.general.sqs.ObservableSqsListener;
import com.xforceplus.general.sqs.event.NamespaceReadyEvent;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/5/16 22:45
 */
public class SqsStartAfterAppReady implements ApplicationContextAware, ApplicationListener<ApplicationReadyEvent> {

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void onApplicationEvent(final ApplicationReadyEvent event) {
        //所有 ObservableSqsListener 都是@Lazy，在启动成功后，主动加载一下
        //应用ready后，主动加载所有SQS bean
        applicationContext.getBeansOfType(ObservableSqsListener.class);
        //通过事件，与threadpool-adapter解耦，让adapter去观察线程池的情况
        applicationContext.publishEvent(new NamespaceReadyEvent());
    }

}
