package com.xforceplus.general.sqs.observablitity;

import com.xforceplus.general.common.ApplicationContextHolder;
import com.xforceplus.general.sqs.event.NamespaceReadyEvent;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhuxingsheng@gmail.com
 * @description: SQS context,暂存SQS的信息
 * @date 2023/5/28 23:46
 */
public class SQSContext {

    private final static List<String> sqsNamespaces = new ArrayList<String>();

    public static synchronized void addNamespace(final String namespace) {
        //以防太多的 NamespacesReadyEvent 被抛出，做个拦截
        if (!sqsNamespaces.contains(namespace)) {
            sqsNamespaces.add(namespace);
            ApplicationContextHolder.getApplicationContext().publishEvent(new NamespaceReadyEvent(namespace));
        }
    }

}
