/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.sqs;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xforceplus.general.starter.logger.annotation.Trace;
import com.xforceplus.xplat.aws.SqsData;
import com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObservableSqsListener
extends AbsSQSListener {
    private static final Logger log = LoggerFactory.getLogger(ObservableSqsListener.class);

    @Trace
    public boolean cusListener(SqsData sqsData) {
        HashMap header;
        String queueName;
        String exceptionClass;
        Timer.Sample sample;
        boolean result;
        long interval;
        block5: {
            interval = 0L;
            result = false;
            String strProperties = sqsData.getProperties();
            sample = Timer.start((MeterRegistry)Metrics.globalRegistry);
            exceptionClass = "none";
            queueName = sqsData.getQueueName();
            header = StringUtils.isNotBlank((CharSequence)strProperties) ? (Map)JSON.parseObject((String)strProperties, Map.class) : Maps.newHashMap();
            log.info("SqsListener,onMessage start queueName:{}  onMessage=messageId:{} header:{} body:{}", new Object[]{queueName, sqsData.getMessageId(), header, sqsData.getMsg()});
            if (!StringUtils.isBlank((CharSequence)sqsData.getMsg())) break block5;
            log.info("SqsListener,onMessage start queueName:{},messageId:{},message body is blank,return", (Object)queueName, (Object)sqsData.getMessageId());
            boolean bl = Boolean.TRUE;
            log.info("SqsListener,onMessage end queueName:{} result:{} interval: {} ms ", new Object[]{queueName, result, interval});
            this.record(sample, queueName, exceptionClass);
            return bl;
        }
        try {
            String strCtx = sqsData.getContext();
            long start = System.currentTimeMillis();
            result = this.onMessage(sqsData.getMessageId(), header, sqsData.getMsg());
            long end = System.currentTimeMillis();
            interval = end - start;
        }
        catch (Exception e) {
            try {
                exceptionClass = e.getClass().getSimpleName();
                log.error("SqsListener,onMessage failed queueName:{} result:{} onMessage=messageId:{} error={}", new Object[]{queueName, result, sqsData.getMessageId(), e.getMessage()});
                log.error("SqsListener,onMessage failed", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                log.info("SqsListener,onMessage end queueName:{} result:{} interval: {} ms ", new Object[]{queueName, result, interval});
                this.record(sample, queueName, exceptionClass);
                throw throwable;
            }
        }
        log.info("SqsListener,onMessage end queueName:{} result:{} interval: {} ms ", new Object[]{queueName, result, interval});
        this.record(sample, queueName, exceptionClass);
        return result;
    }

    private void record(Timer.Sample sample, String queueName, String exceptionClass) {
        this.recordTime(sample, "receive_data_from_sqs", exceptionClass, "action", "receiveSQS", "sqs", queueName);
    }

    public void recordTime(Timer.Sample sample, String metricName, String exceptionClassName, String ... tags) {
        try {
            sample.stop(Timer.builder((String)metricName).tags(tags).tag("exception", exceptionClassName).publishPercentileHistogram(Boolean.valueOf(false)).publishPercentiles(new double[]{0.5, 0.9, 0.99}).register((MeterRegistry)Metrics.globalRegistry));
        }
        catch (Exception e) {
            log.error("recordTime error,metricName:{}", (Object)metricName, (Object)e);
        }
    }

    public abstract boolean onMessage(String var1, Map var2, String var3);
}

