package com.xforceplus.general.threadpool.adapter.monitor;

import static com.xforceplus.general.executor.constants.Constants.HYPHEN_SYMBOL;

import com.xforceplus.general.executor.adapter.ThreadPoolAdapter;
import com.xforceplus.general.threadpool.adapter.monitor.event.ThreadPoolReadyEvent;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/4/9 22:37
 */
@Configuration
public class ThreadPoolAdapterMonitorAutoConfiguration implements ApplicationContextAware, ApplicationListener<ThreadPoolReadyEvent> {

    private ApplicationContext applicationContext;

    @Bean
    public List<ExecutorServiceMetrics> thirdPartyExecutorServiceMetrics() {
        final Map<String, ThreadPoolAdapter> executorMap = applicationContext.getBeansOfType(ThreadPoolAdapter.class);
        final List<ExecutorServiceMetrics> executorServiceMetrics = executorMap.entrySet().stream().map(entry ->
                entry.getValue().executors().entrySet().stream().map(e -> {
                    final ExecutorServiceMetrics esm = new ExecutorServiceMetrics(e.getValue(),
                        entry.getValue().mark() + "-" + e.getKey(),
                        Tags.empty());
                    esm.bindTo(Metrics.globalRegistry);
                    return esm;
                }).collect(Collectors.toList())

            ).flatMap(Collection::stream)
            .collect(Collectors.toList());
        return executorServiceMetrics;
    }

    @Override
    public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void onApplicationEvent(final ThreadPoolReadyEvent event) {
        event.getThreadPoolAdapter().executors().entrySet().stream().forEach(e -> {
            final ExecutorServiceMetrics esm = new ExecutorServiceMetrics(e.getValue(),
                event.getThreadPoolAdapter().mark() + HYPHEN_SYMBOL + e.getKey(),
                Tags.empty());
            esm.bindTo(Metrics.globalRegistry);
        });
    }

}
