/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.threadpool.adapter.rabbitmq;

import com.xforceplus.general.threadpool.adapter.ThreadPoolAdapter;
import com.xforceplus.general.threadpool.adapter.monitor.event.ThreadPoolReadyEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ReflectionUtils;

public class RabbitMQThreadPoolAdapter
implements ThreadPoolAdapter,
ApplicationListener<ApplicationStartedEvent>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQThreadPoolAdapter.class);
    private final Map<String, AbstractConnectionFactory> abstractConnectionFactoryMap;
    private static final String RABBITMQ = "RabbitMQ";
    private static final String FILED_NAME = "executorService";
    private final Map<String, ExecutorService> rabbitmqThreadPoolTaskExecutor = new HashMap<String, ExecutorService>();
    private ApplicationContext applicationContext;

    public String mark() {
        return RABBITMQ;
    }

    public Map<String, ExecutorService> executors() {
        return this.rabbitmqThreadPoolTaskExecutor;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.abstractConnectionFactoryMap.forEach((beanName, abstractConnectionFactor) -> {
            ExecutorService executor = (ExecutorService)ReflectionUtils.getField((Field)FieldUtils.getDeclaredField(AbstractConnectionFactory.class, (String)FILED_NAME, (boolean)true), (Object)abstractConnectionFactor);
            if (Objects.nonNull(executor)) {
                if (executor instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor threadPoolTaskExecutor = (ThreadPoolExecutor)executor;
                    this.rabbitmqThreadPoolTaskExecutor.put((String)beanName, threadPoolTaskExecutor);
                    log.info("Rabbitmq executor name {}", beanName);
                    this.applicationContext.publishEvent((ApplicationEvent)new ThreadPoolReadyEvent((ThreadPoolAdapter)this));
                } else {
                    log.warn("Custom thread pools only support ThreadPoolExecutor");
                }
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public RabbitMQThreadPoolAdapter(Map<String, AbstractConnectionFactory> abstractConnectionFactoryMap) {
        this.abstractConnectionFactoryMap = abstractConnectionFactoryMap;
    }
}

