package com.xforceplus.general.threadpool.adapter.rabbitmq.configuration;

import com.xforceplus.general.threadpool.adapter.rabbitmq.RabbitMQThreadPoolAdapter;
import java.util.Map;
import lombok.RequiredArgsConstructor;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/4/29 20:44
 */
@Configuration
@RequiredArgsConstructor
public class RabbitMQThreadPoolAutoConfiguration {

    private final Map<String, AbstractConnectionFactory> stringAbstractConnectionFactoryMap;

    @Bean
    @ConditionalOnProperty(name = "spring.rabbitmq.host")
    public RabbitMQThreadPoolAdapter rabbitMQThreadPoolAdapter() {
        return new RabbitMQThreadPoolAdapter(stringAbstractConnectionFactoryMap);
    }

}
