package com.xforceplus.general.threadpool.adapter.rabbitmq;

import com.xforceplus.general.executor.adapter.ThreadPoolAdapter;
import com.xforceplus.general.executor.thread.configuration.AdapterThreadPoolProperties;
import com.xforceplus.general.threadpool.adapter.monitor.event.ThreadPoolReadyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ReflectionUtils;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/4/29 20:56
 */
@RequiredArgsConstructor
@Slf4j
public class RabbitMQThreadPoolAdapter implements ThreadPoolAdapter, ApplicationListener<ApplicationStartedEvent>, ApplicationContextAware {

    private final Map<String, AbstractConnectionFactory> abstractConnectionFactoryMap;

    private static final String RABBITMQ = "RabbitMQ";

    private static final String FILED_NAME = "executorService";

    private final Map<String, ExecutorService> rabbitmqThreadPoolTaskExecutor = new HashMap<>();

    @Override
    public String mark() {
        return RABBITMQ;
    }

    @Override
    public Map<String, ExecutorService> executors() {
        return rabbitmqThreadPoolTaskExecutor;
    }

    @Override
    public boolean updateThreadPool(final AdapterThreadPoolProperties threadPoolAdapterParameter) {
        return false;
    }

    @Override
    public void onApplicationEvent(final ApplicationStartedEvent event) {
        abstractConnectionFactoryMap.forEach((beanName, abstractConnectionFactor) -> {
            final ExecutorService executor = (ExecutorService) ReflectionUtils.getField(FieldUtils.getDeclaredField(AbstractConnectionFactory.class, FILED_NAME, true), abstractConnectionFactor);
            if (Objects.nonNull(executor)) {
                if (executor instanceof ThreadPoolExecutor) {
                    final ThreadPoolExecutor threadPoolTaskExecutor = (ThreadPoolExecutor) executor;
                    rabbitmqThreadPoolTaskExecutor.put(beanName, threadPoolTaskExecutor);
                    log.info("Rabbitmq executor name {}", beanName);
                    applicationContext.publishEvent(new ThreadPoolReadyEvent(this));
                } else {
                    log.warn("Custom thread pools only support ThreadPoolExecutor");
                }
            }
        });
    }

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

}
