/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="xforce.general.ultraman.store")
public class UltramanStoreProperties {
    private boolean logEnabled = false;
    private boolean xlogEnabled = true;
    private int defaultPageSize = 1000;

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isXlogEnabled() {
        return this.xlogEnabled;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void setXlogEnabled(boolean xlogEnabled) {
        this.xlogEnabled = xlogEnabled;
    }

    public void setDefaultPageSize(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UltramanStoreProperties)) {
            return false;
        }
        UltramanStoreProperties other = (UltramanStoreProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLogEnabled() != other.isLogEnabled()) {
            return false;
        }
        if (this.isXlogEnabled() != other.isXlogEnabled()) {
            return false;
        }
        return this.getDefaultPageSize() == other.getDefaultPageSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof UltramanStoreProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLogEnabled() ? 79 : 97);
        result = result * 59 + (this.isXlogEnabled() ? 79 : 97);
        result = result * 59 + this.getDefaultPageSize();
        return result;
    }

    public String toString() {
        return "UltramanStoreProperties(logEnabled=" + this.isLogEnabled() + ", xlogEnabled=" + this.isXlogEnabled() + ", defaultPageSize=" + this.getDefaultPageSize() + ")";
    }
}

