/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.log;

import com.google.common.base.Stopwatch;
import com.xforceplus.general.starter.logger.TraceContext;
import com.xforceplus.general.ultraman.configuration.UltramanStoreProperties;
import com.xforceplus.general.ultraman.exception.UltramanException;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.UltramanLogEvent;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xplat.logger.JsonUtil;
import com.xforceplus.xplatalarm.service.XplatExceptionAlarmService;
import io.prometheus.client.Summary;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataStorageLog {
    private static final Logger log = LoggerFactory.getLogger(DataStorageLog.class);
    private final Optional<XplatExceptionAlarmService> alarmService;
    private final UltramanStoreProperties ultramanStoreProperties;
    private final XlogProperties xlogProperties;
    private final LogSender logSender;
    private final ContextService contextService;
    @Qualifier(value="ultramanSummary")
    private final Summary ultramanSummary;

    @Pointcut(value="@annotation(com.xforceplus.general.ultraman.log.UltramanLog)")
    public void logCut() {
    }

    public void warning(String methodName, Exception error, Object ... args) {
        this.alarmService.ifPresent(service -> service.createNotice(TraceContext.getTraceId(), (Throwable)error, methodName, new ArrayList<Object>(Arrays.asList(args)).toArray()));
    }

    private String getEntityClassCode(ProceedingJoinPoint joinPoint) {
        IEntityClass entityClass = null;
        try {
            entityClass = (IEntityClass)MethodUtils.invokeMethod((Object)joinPoint.getThis(), (String)"entityClass");
        }
        catch (Exception e) {
            log.warn("getEntityClass error:{}", (Object)e.getMessage(), (Object)e);
        }
        return Optional.ofNullable(entityClass).map(IEntityClass::code).orElse("");
    }

    @Around(value="logCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = joinPoint.getTarget().getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        String methodName = method.getName();
        Object[] params = joinPoint.getArgs();
        String entityCode = this.getEntityClassCode(joinPoint);
        Stopwatch stopwatch = Stopwatch.createStarted();
        UltramanLogEvent ultramanLogEvent = new UltramanLogEvent();
        ultramanLogEvent.setRequestText(JsonUtil.toJson((Object)params));
        ultramanLogEvent.setRequestSize(ultramanLogEvent.getRequestText().getBytes(StandardCharsets.UTF_8).length);
        ultramanLogEvent.setName(method.getName() + ":" + entityCode);
        ultramanLogEvent.setMethod(method.getName());
        ultramanLogEvent.setStoreName(this.xlogProperties.getStoreName());
        ultramanLogEvent.setType("Ultraman");
        ultramanLogEvent.setTraceId(LogContext.getTraceId());
        ultramanLogEvent.setEntityCode(entityCode);
        String error = "";
        Object result = null;
        try {
            result = joinPoint.proceed();
            ultramanLogEvent.setResponseText(com.xforceplus.general.utils.json.JsonUtil.toJsonString((Object)result));
            ultramanLogEvent.setResponseSize(ultramanLogEvent.getResponseText().getBytes(StandardCharsets.UTF_8).length);
            ultramanLogEvent.setSuccessful(true);
        }
        catch (Exception e) {
            error = e.getMessage();
            this.warning(methodName, e, new Object[0]);
            log.error("ultraman error,method:{},{}", new Object[]{methodName, error, e});
            ultramanLogEvent.setThrowable((Throwable)e);
            ultramanLogEvent.setSuccessful(false);
            throw new UltramanException(methodName + "\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        finally {
            this.record(method, entityCode, params, stopwatch, result, error, ultramanLogEvent);
        }
        return result;
    }

    private void record(Method method, String entityCode, Object[] params, Stopwatch stopwatch, Object result, String error, UltramanLogEvent ultramanLogEvent) {
        this.printLog(method, entityCode, params, stopwatch, result, error);
        if (this.ultramanStoreProperties.isXlogEnabled()) {
            this.logSender.send((LogEvent)ultramanLogEvent);
        }
        try {
            long cost = stopwatch.elapsed().toMillis();
            ((Summary.Child)this.ultramanSummary.labels(new String[]{method.getName()})).observe((double)cost);
        }
        catch (Exception e) {
            log.error("uploadOqsInfo error entityClass[{}][{}] {}", new Object[]{entityCode, method.getName(), e.getMessage(), e});
        }
    }

    private void printLog(Method method, String entityCode, Object[] params, Stopwatch stopwatch, Object result, String error) {
        if (!this.ultramanStoreProperties.isLogEnabled()) {
            return;
        }
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        Long userId = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ID);
        String userName = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME);
        String parameters = com.xforceplus.general.utils.json.JsonUtil.toJsonString((Object)params);
        String ret = com.xforceplus.general.utils.json.JsonUtil.toJsonString((Object)result);
        log.info("xlog:{},method:{},entity:{},userName:{},userId:{},tenantId:{},tenantCode:{},duration:{},params:\u3010{}\u3011,result:\u3010{}\u3011,success:{}", new Object[]{LogContext.getTraceId(), method.getName(), entityCode, userName, userId, tenantId, tenantCode, stopwatch.toString(), parameters, ret, StringUtils.isBlank((CharSequence)error)});
    }

    public DataStorageLog(Optional<XplatExceptionAlarmService> alarmService, UltramanStoreProperties ultramanStoreProperties, XlogProperties xlogProperties, LogSender logSender, ContextService contextService, Summary ultramanSummary) {
        this.alarmService = alarmService;
        this.ultramanStoreProperties = ultramanStoreProperties;
        this.xlogProperties = xlogProperties;
        this.logSender = logSender;
        this.contextService = contextService;
        this.ultramanSummary = ultramanSummary;
    }
}

