/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.store;

import cn.hutool.core.util.ReflectUtil;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.xforceplus.general.ultraman.DataStoreFacade;
import com.xforceplus.general.ultraman.configuration.UltramanStoreProperties;
import com.xforceplus.general.ultraman.log.UltramanLog;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityId;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityInstance;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityKey;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.service.BusinessFacade;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.ultraman.oqsengine.sdk.vo.Page;
import com.xforceplus.ultraman.oqsengine.sdk.vo.Summary;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import io.vavr.Tuple2;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractDataStoreAdapter<T>
implements DataStoreFacade<T>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataStoreAdapter.class);
    private ApplicationContext context;
    private UltramanStoreProperties ultramanStoreProperties;
    private BusinessFacade businessFacade;
    private String entityCode;
    private Class<T> targetClass;

    public AbstractDataStoreAdapter() {
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.targetClass = (Class)pt.getActualTypeArguments()[0];
        this.entityCode = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.targetClass.getSimpleName());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.ultramanStoreProperties = (UltramanStoreProperties)this.context.getBean(UltramanStoreProperties.class);
        this.businessFacade = (BusinessFacade)this.context.getBean(BusinessFacade.class);
    }

    public IEntityClass getEntityClass() {
        return this.businessFacade.load(this.entityCode);
    }

    @Override
    @UltramanLog
    public Long countAll() {
        return this.businessFacade.countAll(this.getEntityClass());
    }

    @Override
    @UltramanLog
    public Long count(ConditionQueryRequest request) {
        return this.businessFacade.count(this.getEntityClass(), (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    @UltramanLog
    public Long count(ExpQuery query) {
        return this.businessFacade.count(this.getEntityClass(), (ExpRel)query);
    }

    @Override
    @UltramanLog
    public Long insert(Map<String, Object> value) {
        return this.businessFacade.create(this.getEntityClass(), value);
    }

    @Override
    @UltramanLog
    public Long insert(T model) {
        return this.insert(model, null);
    }

    @Override
    @UltramanLog
    public Long insert(T model, Map<String, Object> extValue) {
        Map<String, Object> values = this.toOqsMap(model);
        if (MapUtils.isNotEmpty(extValue)) {
            values.putAll(extValue);
        }
        return this.insert((T)values);
    }

    @Override
    @UltramanLog
    public Integer insertBatch(List<T> models) {
        List<Map<String, Object>> values = models.stream().map(this::toOqsMap).collect(Collectors.toList());
        return this.insertBatchMap(values);
    }

    @Override
    @UltramanLog
    public Integer insertBatchMap(List<Map<String, Object>> values) {
        return this.businessFacade.createMulti(this.getEntityClass(), values);
    }

    @Override
    @UltramanLog
    public Integer deleteById(Long id) {
        return this.businessFacade.deleteOne(EntityId.of((IEntityClass)this.getEntityClass(), (long)id));
    }

    @Override
    @UltramanLog
    public Integer deleteBatch(List<Long> ids) {
        return this.businessFacade.deleteMulti(ids.stream().map(id -> EntityId.of((IEntityClass)this.getEntityClass(), (long)id)).collect(Collectors.toList()));
    }

    @Override
    @UltramanLog
    public Integer deleteOneByKeys(Tuple2<String, Object> ... keyValues) {
        return this.businessFacade.deleteByKey(EntityKey.of((IEntityClass)this.getEntityClass(), keyValues));
    }

    @Override
    @UltramanLog
    public Integer deleteByCondition(ConditionQueryRequest request) {
        return this.businessFacade.deleteByCondition(this.getEntityClass(), (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    @UltramanLog
    public Integer deleteByCondition(ExpQuery query) {
        return this.businessFacade.deleteByCondition(this.getEntityClass(), (ExpRel)query);
    }

    @Override
    @UltramanLog
    public Integer deleteBatchByCondition(ConditionQueryRequest request) {
        return this.businessFacade.deleteByConditionByBatch(this.getEntityClass(), (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    @UltramanLog
    public Integer deleteBatchByCondition(ExpQuery query) {
        return this.businessFacade.deleteByConditionByBatch(this.getEntityClass(), (ExpRel)query);
    }

    @Override
    @UltramanLog
    public Integer updateById(T model) {
        Long identity = (Long)ReflectUtil.invoke(model, (String)"getId", (Object[])new Object[0]);
        return Optional.ofNullable(identity).map(id -> this.businessFacade.updateById(EntityId.of((IEntityClass)this.getEntityClass(), (long)id), this.toOqsMap(model))).orElse(null);
    }

    @Override
    @UltramanLog
    public Integer updateById(Map<String, Object> value, Long id) {
        return this.businessFacade.updateById(EntityId.of((IEntityClass)this.getEntityClass(), (long)id), value);
    }

    @Override
    @UltramanLog
    public Integer updateBatch(List<T> models) {
        List dataList = models.stream().map(this::toOqsMap).collect(Collectors.toList());
        return this.businessFacade.updateMulti(this.getEntityClass(), dataList);
    }

    @Override
    @UltramanLog
    public Integer updateBatchMap(List<Map<String, Object>> values) {
        List dataList = values.stream().filter(v -> MapUtils.getLong((Map)v, (Object)"id") != null).collect(Collectors.toList());
        return this.businessFacade.updateMulti(this.getEntityClass(), dataList);
    }

    @Override
    @UltramanLog
    public Integer updateByKeys(Map<String, Object> value, Tuple2<String, Object> ... keyValues) {
        return this.businessFacade.updateByKey(EntityKey.of((IEntityClass)this.getEntityClass(), keyValues), value);
    }

    @Override
    @UltramanLog
    public List<T> findAllWithoutPageAndSort(ConditionQueryRequest request) {
        Iterator instanceIterator = this.businessFacade.findAll(this.getEntityClass(), (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(this.fromOqsMap(instance.getRecord().toMap(null)));
        }
        return dataList;
    }

    @Override
    @UltramanLog
    public List<T> findAllWithoutPageAndSort(ExpQuery expQuery) {
        Iterator instanceIterator = this.businessFacade.findAll(this.getEntityClass(), (ExpRel)expQuery);
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(this.fromOqsMap(instance.getRecord().toMap(null)));
        }
        return dataList;
    }

    @Override
    @UltramanLog
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(ConditionQueryRequest request) {
        Iterator instanceIterator = this.businessFacade.findAll(this.getEntityClass(), (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(instance.getRecord().toMap(null));
        }
        return dataList;
    }

    @Override
    @UltramanLog
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(ExpQuery expQuery) {
        Iterator instanceIterator = this.businessFacade.findAll(this.getEntityClass(), (ExpRel)expQuery);
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(instance.getRecord().toMap(null));
        }
        return dataList;
    }

    @Override
    @UltramanLog
    public Page<T> findPageByCondition(ConditionQueryRequest request) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(this.getEntityClass(), (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> this.fromOqsMap(a.getRecord().toMap(null))).collect(Collectors.toList()), summary, (long)request.getPageSize().intValue(), (long)request.getPageNo().intValue());
    }

    @Override
    @UltramanLog
    public Page<T> findPageByCondition(ExpQuery query) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(this.getEntityClass(), (ExpRel)this.defaultPageIfNull(query));
        ExpRange range = query.getRange();
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> this.fromOqsMap(a.getRecord().toMap(null))).collect(Collectors.toList()), summary, (long)range.getIndex().intValue(), (long)range.getSize().intValue());
    }

    @Override
    @UltramanLog
    public Page<Map<String, Object>> findPageMapByCondition(ConditionQueryRequest request) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(this.getEntityClass(), (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()), summary, (long)request.getPageSize().intValue(), (long)request.getPageNo().intValue());
    }

    @Override
    @UltramanLog
    public Page<Map<String, Object>> findPageMapByCondition(ExpQuery query) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(this.getEntityClass(), (ExpRel)this.defaultPageIfNull(query));
        ExpRange range = query.getRange();
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()), summary, (long)range.getIndex().intValue(), (long)range.getSize().intValue());
    }

    @Override
    @UltramanLog
    public List<T> findByCondition(ConditionQueryRequest request) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(this.getEntityClass(), (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        return instanceIterator.getRows().stream().map(a -> this.fromOqsMap(a.getRecord().toMap(null))).collect(Collectors.toList());
    }

    @Override
    @UltramanLog
    public List<T> findByCondition(ExpQuery expQuery) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(this.getEntityClass(), (ExpRel)this.defaultPageIfNull(expQuery));
        return instanceIterator.getRows().stream().map(a -> this.fromOqsMap(a.getRecord().toMap(null))).collect(Collectors.toList());
    }

    @Override
    @UltramanLog
    public List<Map<String, Object>> findByConditionMap(ConditionQueryRequest request) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(this.getEntityClass(), (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        return instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList());
    }

    @Override
    @UltramanLog
    public List<Map<String, Object>> findByConditionMap(ExpQuery expQuery) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(this.getEntityClass(), (ExpRel)this.defaultPageIfNull(expQuery));
        return instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList());
    }

    @Override
    @UltramanLog
    public T findOneById(Long id) {
        return this.fromOqsMap(this.findOneMapById(id));
    }

    @Override
    @UltramanLog
    public Map<String, Object> findOneMapById(Long id) {
        Optional instanceOptional = this.businessFacade.findOne(EntityId.of((IEntityClass)this.getEntityClass(), (long)id));
        return instanceOptional.map(entityInstance -> entityInstance.getRecord().toMap(null)).orElse(null);
    }

    @Override
    @UltramanLog
    public T findOneByKeys(Tuple2<String, Object> ... keyValues) {
        Optional instanceOptional = this.businessFacade.findOneByKey(EntityKey.of((IEntityClass)this.getEntityClass(), keyValues));
        return instanceOptional.map(entityInstance -> this.fromOqsMap(entityInstance.getRecord().toMap(null))).orElse(null);
    }

    @Override
    @UltramanLog
    public Map<String, Object> findOneMapByKeys(Tuple2<String, Object> ... keyValues) {
        Optional instanceOptional = this.businessFacade.findOneByKey(EntityKey.of((IEntityClass)this.getEntityClass(), keyValues));
        return instanceOptional.map(entityInstance -> entityInstance.getRecord().toMap(null)).orElse(null);
    }

    private T fromOqsMap(Map<String, Object> map) {
        return (T)(MapUtils.isEmpty(map) ? null : ReflectUtil.invoke((Object)ReflectUtil.newInstance(this.targetClass, (Object[])new Object[0]), (String)"fromOQSMap", (Object[])new Object[]{map}));
    }

    private Map<String, Object> toOqsMap(T model) {
        return null == model ? Collections.emptyMap() : (Map)ReflectUtil.invoke(model, (String)"toOQSMap", (Object[])new Object[0]);
    }

    private ConditionQueryRequest defaultPageIfNull(ConditionQueryRequest request) {
        if (request.getPageNo() == null) {
            request.setPageNo(Integer.valueOf(1));
        }
        if (request.getPageSize() == null) {
            request.setPageSize(Integer.valueOf(this.ultramanStoreProperties.getDefaultPageSize()));
        }
        return request;
    }

    private ExpQuery defaultPageIfNull(ExpQuery query) {
        if (null == query.getRange()) {
            query.setRange(new ExpRange(Integer.valueOf(1), Integer.valueOf(this.ultramanStoreProperties.getDefaultPageSize())));
        }
        return query;
    }
}

