/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.advice;

import com.google.common.base.Stopwatch;
import com.xforceplus.general.starter.logger.TraceContext;
import com.xforceplus.general.ultraman.configuration.UltramanStoreProperties;
import com.xforceplus.general.ultraman.exception.UltramanException;
import com.xforceplus.general.utils.json.JsonUtil;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.TenantInfo;
import com.xforceplus.xlog.core.model.impl.UltramanLogEvent;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xplatalarm.service.XplatExceptionAlarmService;
import io.prometheus.client.Summary;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataStorageAdvice {
    private static final Logger log = LoggerFactory.getLogger(DataStorageAdvice.class);
    private final Optional<XplatExceptionAlarmService> alarmService;
    private final UltramanStoreProperties ultramanStoreProperties;
    private final Optional<XlogProperties> xlogProperties;
    private final Optional<LogSender> logSender;
    private final ContextService contextService;
    @Qualifier(value="ultramanSummary")
    private final Summary ultramanSummary;

    @Pointcut(value="@annotation(com.xforceplus.general.ultraman.log.UltramanLog)")
    public void logCut() {
    }

    public void warning(String methodName, Exception error, Object ... args) {
        this.alarmService.ifPresent(service -> service.createNotice(TraceContext.getTraceId(), (Throwable)error, methodName, new ArrayList<Object>(Arrays.asList(args)).toArray()));
    }

    private String getEntityClassCode(Object entity) {
        IEntityClass entityClass = null;
        if (entity instanceof IEntityClass) {
            entityClass = (IEntityClass)entity;
        } else {
            log.warn("getEntityClass error,first param is not entity");
        }
        return Optional.ofNullable(entityClass).map(IEntityClass::code).orElse("");
    }

    @Around(value="logCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = joinPoint.getTarget().getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        String methodName = method.getName();
        Object[] params = joinPoint.getArgs();
        String entityCode = this.getEntityClassCode(params[0]);
        Stopwatch stopwatch = Stopwatch.createStarted();
        UltramanLogEvent ultramanLogEvent = this.createUltramanLogEvent(method, params, entityCode);
        String error = "";
        Object result = null;
        try {
            result = joinPoint.proceed();
            ultramanLogEvent.setResponseText(JsonUtil.toJsonString((Object)result));
            ultramanLogEvent.setResponseSize(ultramanLogEvent.getResponseText().getBytes(StandardCharsets.UTF_8).length);
            ultramanLogEvent.setSuccessful(true);
        }
        catch (Exception e) {
            error = e.getMessage();
            this.warning(methodName, e, new Object[0]);
            log.error("ultraman error,method:{},{}", new Object[]{methodName, error, e});
            ultramanLogEvent.setThrowable((Throwable)e);
            ultramanLogEvent.setSuccessful(false);
            throw new UltramanException(methodName + "\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        finally {
            this.record(method, entityCode, stopwatch, ultramanLogEvent);
        }
        return result;
    }

    @NotNull
    private UltramanLogEvent createUltramanLogEvent(Method method, Object[] params, String entityCode) {
        UltramanLogEvent ultramanLogEvent = new UltramanLogEvent();
        Object[] logParams = ArrayUtils.subarray((Object[])params, (int)1, (int)params.length);
        ultramanLogEvent.setRequestText(JsonUtil.toJsonString((Object)logParams));
        ultramanLogEvent.setRequestSize(ultramanLogEvent.getRequestText().getBytes(StandardCharsets.UTF_8).length);
        ultramanLogEvent.setName(method.getName() + ":" + entityCode);
        ultramanLogEvent.setMethod(method.getName());
        ultramanLogEvent.setStoreName(this.xlogProperties.map(XlogProperties::getStoreName).orElse(""));
        ultramanLogEvent.setType("Ultraman");
        ultramanLogEvent.setTraceId(LogContext.getTraceId());
        ultramanLogEvent.setEntityCode(entityCode);
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        String userName = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME);
        TenantInfo tenantInfo = new TenantInfo();
        tenantInfo.setTenantId(tenantId);
        tenantInfo.setTenantCode(tenantCode);
        tenantInfo.setUsername(userName);
        ultramanLogEvent.setTenantInfo(tenantInfo);
        return ultramanLogEvent;
    }

    private void record(Method method, String entityCode, Stopwatch stopwatch, UltramanLogEvent ultramanLogEvent) {
        this.printLog(ultramanLogEvent, stopwatch);
        if (this.xlogProperties.map(p -> p.getUltraman().isEnabled()).orElse(false).booleanValue()) {
            this.logSender.ifPresent(s -> s.send((LogEvent)ultramanLogEvent));
        }
        try {
            long cost = stopwatch.elapsed().toMillis();
            ((Summary.Child)this.ultramanSummary.labels(new String[]{method.getName()})).observe((double)cost);
        }
        catch (Exception e) {
            log.error("uploadOqsInfo error entityClass[{}][{}] {}", new Object[]{entityCode, method.getName(), e.getMessage(), e});
        }
    }

    private void printLog(UltramanLogEvent ultramanLogEvent, Stopwatch stopwatch) {
        if (!this.ultramanStoreProperties.isLogEnabled()) {
            return;
        }
        Long userId = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ID);
        String parameters = "nonlog";
        if (this.ultramanStoreProperties.isLogRequestEnabled()) {
            parameters = ultramanLogEvent.getRequestText();
        }
        String result = "nonlog";
        if (this.ultramanStoreProperties.isLogResponseEnabled()) {
            result = ultramanLogEvent.getResponseText();
        }
        log.info("method:{},entity:{},userName:{},userId:{},tenantId:{},tenantCode:{},duration:{},params:\u3010{}\u3011,result:\u3010{}\u3011,success:{}", new Object[]{ultramanLogEvent.getMethod(), ultramanLogEvent.getEntityCode(), ultramanLogEvent.getTenantInfo().getUsername(), userId, ultramanLogEvent.getTenantInfo().getTenantId(), ultramanLogEvent.getTenantInfo().getTenantCode(), stopwatch.toString(), parameters, result, ultramanLogEvent.isSuccessful()});
    }

    public DataStorageAdvice(Optional<XplatExceptionAlarmService> alarmService, UltramanStoreProperties ultramanStoreProperties, Optional<XlogProperties> xlogProperties, Optional<LogSender> logSender, ContextService contextService, @Qualifier(value="ultramanSummary") Summary ultramanSummary) {
        this.alarmService = alarmService;
        this.ultramanStoreProperties = ultramanStoreProperties;
        this.xlogProperties = xlogProperties;
        this.logSender = logSender;
        this.contextService = contextService;
        this.ultramanSummary = ultramanSummary;
    }
}

