/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.store;

import cn.hutool.core.util.ReflectUtil;
import com.google.common.collect.Lists;
import com.xforceplus.general.ultraman.configuration.UltramanStoreProperties;
import com.xforceplus.general.ultraman.log.UltramanLog;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityId;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityInstance;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityKey;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.service.BusinessFacade;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.util.RequestBuilder;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.ultraman.oqsengine.sdk.vo.Page;
import com.xforceplus.ultraman.oqsengine.sdk.vo.Summary;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Component;

@Component
public class UltramanDataStoreFacadeWrapper {
    private final BusinessFacade businessFacade;
    private final UltramanStoreProperties ultramanStoreProperties;

    @UltramanLog
    public Long countAll(IEntityClass entityClass) {
        return this.businessFacade.countAll(entityClass);
    }

    @UltramanLog
    public Long count(IEntityClass entityClass, ConditionQueryRequest request) {
        return this.businessFacade.count(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @UltramanLog
    public Long count(IEntityClass entityClass, ExpQuery query) {
        return this.businessFacade.count(entityClass, (ExpRel)query);
    }

    @UltramanLog
    public Long insert(IEntityClass entityClass, Map<String, Object> value) {
        return this.businessFacade.create(entityClass, value);
    }

    @UltramanLog
    public <T> Long insert(IEntityClass entityClass, T model) {
        return this.insert(entityClass, model, null);
    }

    @UltramanLog
    public <T> Long insert(IEntityClass entityClass, T model, Map<String, Object> extValue) {
        Map<String, Object> values = this.toOqsMap(model);
        if (MapUtils.isNotEmpty(extValue)) {
            values.putAll(extValue);
        }
        return this.insert(entityClass, (T)values);
    }

    @UltramanLog
    public <T> Integer insertBatch(IEntityClass entityClass, List<T> models) {
        List<Map<String, Object>> values = models.stream().map(this::toOqsMap).collect(Collectors.toList());
        return this.insertBatchMap(entityClass, values);
    }

    @UltramanLog
    public <T> Integer insertBatchMap(IEntityClass entityClass, List<Map<String, Object>> values) {
        return this.businessFacade.createMulti(entityClass, values);
    }

    @UltramanLog
    public Integer deleteById(IEntityClass entityClass, Long id) {
        return this.businessFacade.deleteOne(EntityId.of((IEntityClass)entityClass, (long)id));
    }

    @UltramanLog
    public Integer deleteBatch(IEntityClass entityClass, List<Long> ids) {
        return this.businessFacade.deleteMulti(ids.stream().map(id -> EntityId.of((IEntityClass)entityClass, (long)id)).collect(Collectors.toList()));
    }

    @UltramanLog
    public Integer deleteOneByKeys(IEntityClass entityClass, Tuple2<String, Object> ... keyValues) {
        return this.businessFacade.deleteByKey(EntityKey.of((IEntityClass)entityClass, keyValues));
    }

    @UltramanLog
    public Integer deleteByCondition(IEntityClass entityClass, ConditionQueryRequest request) {
        return this.businessFacade.deleteByCondition(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @UltramanLog
    public Integer deleteByCondition(IEntityClass entityClass, ExpQuery query) {
        return this.businessFacade.deleteByCondition(entityClass, (ExpRel)query);
    }

    @UltramanLog
    public Integer deleteBatchByCondition(IEntityClass entityClass, ConditionQueryRequest request) {
        return this.businessFacade.deleteByConditionByBatch(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @UltramanLog
    public Integer deleteBatchByCondition(IEntityClass entityClass, ExpQuery query) {
        return this.businessFacade.deleteByConditionByBatch(entityClass, (ExpRel)query);
    }

    @UltramanLog
    public <T> Integer updateById(IEntityClass entityClass, T model) {
        Long identity = (Long)ReflectUtil.invoke(model, (String)"getId", (Object[])new Object[0]);
        return Optional.ofNullable(identity).map(id -> this.businessFacade.updateById(EntityId.of((IEntityClass)entityClass, (long)id), this.toOqsMap(model))).orElse(null);
    }

    @UltramanLog
    public Integer updateById(IEntityClass entityClass, Map<String, Object> updateData, Long id) {
        return this.businessFacade.updateById(EntityId.of((IEntityClass)entityClass, (long)id), updateData);
    }

    @UltramanLog
    public <T> Integer updateBatch(IEntityClass entityClass, List<T> models) {
        List dataList = models.stream().map(this::toOqsMap).collect(Collectors.toList());
        return this.businessFacade.updateMulti(entityClass, dataList);
    }

    @UltramanLog
    public Integer updateBatchMap(IEntityClass entityClass, List<Map<String, Object>> values) {
        List dataList = values.stream().filter(v -> MapUtils.getLong((Map)v, (Object)"id") != null).collect(Collectors.toList());
        return this.businessFacade.updateMulti(entityClass, dataList);
    }

    @UltramanLog
    public Integer updateByKeys(IEntityClass entityClass, Map<String, Object> updateData, Tuple2<String, Object> ... conditionKeyValues) {
        return this.businessFacade.updateByKey(EntityKey.of((IEntityClass)entityClass, conditionKeyValues), updateData);
    }

    @UltramanLog
    public Integer updateByCondition(IEntityClass entityClass, Map<String, Object> updateData, ConditionQueryRequest queryRequest) {
        return this.businessFacade.updateByCondition(entityClass, updateData, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)queryRequest));
    }

    @UltramanLog
    public <T> List<T> findAllWithoutPageAndSort(IEntityClass entityClass, Class<T> entityClazz, ConditionQueryRequest request) {
        Iterator instanceIterator = this.businessFacade.findAll(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(this.fromOqsMap(entityClazz, instance.getRecord().toMap(null)));
        }
        return dataList;
    }

    @UltramanLog
    public <T> List<T> findAllWithoutPageAndSort(IEntityClass entityClass, Class<T> entityClazz, ExpQuery expQuery) {
        Iterator instanceIterator = this.businessFacade.findAll(entityClass, (ExpRel)expQuery);
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(this.fromOqsMap(entityClazz, instance.getRecord().toMap(null)));
        }
        return dataList;
    }

    @UltramanLog
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(IEntityClass entityClass, ConditionQueryRequest request) {
        Iterator instanceIterator = this.businessFacade.findAll(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(instance.getRecord().toMap(null));
        }
        return dataList;
    }

    @UltramanLog
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(IEntityClass entityClass, ExpQuery expQuery) {
        Iterator instanceIterator = this.businessFacade.findAll(entityClass, (ExpRel)expQuery);
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(instance.getRecord().toMap(null));
        }
        return dataList;
    }

    @UltramanLog
    public Page<T> findPageByCondition(IEntityClass entityClass, Class<T> entityClazz, ConditionQueryRequest request) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> (T)this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList()), summary, (long)request.getPageSize().intValue(), (long)request.getPageNo().intValue());
    }

    @UltramanLog
    public <T> Page<T> findPageByCondition(IEntityClass entityClass, Class<T> entityClazz, ExpQuery query) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(entityClass, (ExpRel)this.defaultPageIfNull(query));
        ExpRange range = query.getRange();
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList()), summary, (long)range.getIndex().intValue(), (long)range.getSize().intValue());
    }

    @UltramanLog
    public Page<Map<String, Object>> findPageMapByCondition(IEntityClass entityClass, ConditionQueryRequest request) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()), summary, (long)request.getPageSize().intValue(), (long)request.getPageNo().intValue());
    }

    @UltramanLog
    public Page<Map<String, Object>> findPageMapByCondition(IEntityClass entityClass, ExpQuery query) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(entityClass, (ExpRel)this.defaultPageIfNull(query));
        ExpRange range = query.getRange();
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()), summary, (long)range.getIndex().intValue(), (long)range.getSize().intValue());
    }

    @UltramanLog
    public <T> List<T> findByCondition(IEntityClass entityClass, Class<T> entityClazz, ConditionQueryRequest request) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        return instanceIterator.getRows().stream().map(a -> this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList());
    }

    @UltramanLog
    public <T> List<T> findByCondition(IEntityClass entityClass, Class<T> entityClazz, ExpQuery expQuery) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(entityClass, (ExpRel)this.defaultPageIfNull(expQuery));
        return instanceIterator.getRows().stream().map(a -> this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList());
    }

    @UltramanLog
    public List<Map<String, Object>> findByConditionMap(IEntityClass entityClass, ConditionQueryRequest request) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        return instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList());
    }

    @UltramanLog
    public List<Map<String, Object>> findByConditionMap(IEntityClass entityClass, ExpQuery expQuery) {
        DataCollection instanceIterator = this.businessFacade.findByCondition(entityClass, (ExpRel)this.defaultPageIfNull(expQuery));
        return instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList());
    }

    @UltramanLog
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(IEntityClass entityClass, ConditionQueryRequest request) {
        DataCollection dataCollection = this.businessFacade.findByCondition(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        return new DataCollection(dataCollection.getRowNum(), dataCollection.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()));
    }

    @UltramanLog
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(IEntityClass entityClass, ExpRel expRel) {
        DataCollection dataCollection = this.businessFacade.findByCondition(entityClass, expRel);
        return new DataCollection(dataCollection.getRowNum(), dataCollection.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()));
    }

    @UltramanLog
    public DataCollection<Map<String, Object>> findCollectionMapByIds(IEntityClass entityClass, List<Long> ids) {
        RequestBuilder builder = new RequestBuilder().field("id", ConditionOp.in, ids);
        builder.pageSize(Integer.valueOf(ids.size())).pageNo(Integer.valueOf(1));
        DataCollection dataCollection = this.businessFacade.findByCondition(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)builder.build()));
        return new DataCollection(dataCollection.getRowNum(), dataCollection.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()));
    }

    @UltramanLog
    public <T> T findOneById(IEntityClass entityClass, Class<T> entityClazz, Long id) {
        return this.fromOqsMap(entityClazz, this.findOneMapById(entityClass, id));
    }

    @UltramanLog
    public Map<String, Object> findOneMapById(IEntityClass entityClass, Long id) {
        Optional instanceOptional = this.businessFacade.findOne(EntityId.of((IEntityClass)entityClass, (long)id));
        return instanceOptional.map(entityInstance -> entityInstance.getRecord().toMap(null)).orElse(null);
    }

    @UltramanLog
    public <T> T findOneByKeys(IEntityClass entityClass, Class<T> entityClazz, Tuple2<String, Object> ... keyValues) {
        Optional instanceOptional = this.businessFacade.findOneByKey(EntityKey.of((IEntityClass)entityClass, keyValues));
        return instanceOptional.map(entityInstance -> this.fromOqsMap(entityClazz, entityInstance.getRecord().toMap(null))).orElse(null);
    }

    @UltramanLog
    public Map<String, Object> findOneMapByKeys(IEntityClass entityClass, Tuple2<String, Object> ... keyValues) {
        Optional instanceOptional = this.businessFacade.findOneByKey(EntityKey.of((IEntityClass)entityClass, keyValues));
        return instanceOptional.map(entityInstance -> entityInstance.getRecord().toMap(null)).orElse(null);
    }

    private <T> T fromOqsMap(Class<T> entityClazz, Map<String, Object> map) {
        return (T)(MapUtils.isEmpty(map) ? null : ReflectUtil.invoke((Object)ReflectUtil.newInstance(entityClazz, (Object[])new Object[0]), (String)"fromOQSMap", (Object[])new Object[]{map}));
    }

    private <T> Map<String, Object> toOqsMap(T model) {
        return null == model ? Collections.emptyMap() : (Map)ReflectUtil.invoke(model, (String)"toOQSMap", (Object[])new Object[0]);
    }

    public IEntityClass load(String entityCode) {
        return this.businessFacade.load(entityCode);
    }

    private ConditionQueryRequest defaultPageIfNull(ConditionQueryRequest request) {
        if (request.getPageNo() == null) {
            request.setPageNo(Integer.valueOf(1));
        }
        if (request.getPageSize() == null) {
            request.setPageSize(Integer.valueOf(this.ultramanStoreProperties.getDefaultPageSize()));
        }
        return request;
    }

    private ExpQuery defaultPageIfNull(ExpQuery query) {
        if (null == query.getRange()) {
            query.setRange(new ExpRange(Integer.valueOf(1), Integer.valueOf(this.ultramanStoreProperties.getDefaultPageSize())));
        }
        return query;
    }

    public UltramanDataStoreFacadeWrapper(BusinessFacade businessFacade, UltramanStoreProperties ultramanStoreProperties) {
        this.businessFacade = businessFacade;
        this.ultramanStoreProperties = ultramanStoreProperties;
    }
}

