/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.store;

import com.google.common.base.CaseFormat;
import com.xforceplus.general.ultraman.DataStoreFacade;
import com.xforceplus.general.ultraman.sharding.ShardingInfo;
import com.xforceplus.general.ultraman.store.UltramanDataStoreFacadeWrapper;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.ultraman.oqsengine.sdk.vo.Page;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import io.vavr.Tuple2;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractDataStoreAdapter<T>
implements DataStoreFacade<T>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataStoreAdapter.class);
    private ApplicationContext context;
    private UltramanDataStoreFacadeWrapper businessFacadeWrapper;
    private String entityCode;
    private Class<T> targetClass;

    public AbstractDataStoreAdapter() {
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.targetClass = (Class)pt.getActualTypeArguments()[0];
        this.entityCode = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.targetClass.getSimpleName());
    }

    public IEntityClass entityClass() {
        return this.businessFacadeWrapper.load(this.entityCode);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.businessFacadeWrapper = (UltramanDataStoreFacadeWrapper)this.context.getBean(UltramanDataStoreFacadeWrapper.class);
    }

    @Override
    public Long countAll(ShardingInfo shardingInfo) {
        return this.businessFacadeWrapper.countAll(this.entityClass(), shardingInfo);
    }

    @Override
    public Long count(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.count(this.entityClass(), shardingInfo, request);
    }

    @Override
    public Long count(ShardingInfo shardingInfo, ExpQuery query) {
        return this.businessFacadeWrapper.count(this.entityClass(), shardingInfo, query);
    }

    @Override
    public Long insert(ShardingInfo shardingInfo, Map<String, Object> value) {
        return this.businessFacadeWrapper.insert(this.entityClass(), shardingInfo, value);
    }

    @Override
    public Long insert(ShardingInfo shardingInfo, T model) {
        return this.businessFacadeWrapper.insert(this.entityClass(), shardingInfo, model);
    }

    @Override
    public Long insert(ShardingInfo shardingInfo, T model, Map<String, Object> extValue) {
        return this.businessFacadeWrapper.insert(this.entityClass(), shardingInfo, model, extValue);
    }

    @Override
    public Integer insertBatch(ShardingInfo shardingInfo, List<T> models) {
        return this.businessFacadeWrapper.insertBatch(this.entityClass(), shardingInfo, models);
    }

    @Override
    public Integer insertBatchMap(ShardingInfo shardingInfo, List<Map<String, Object>> values) {
        return this.businessFacadeWrapper.insertBatchMap(this.entityClass(), shardingInfo, values);
    }

    @Override
    public Integer deleteById(ShardingInfo shardingInfo, Long id) {
        return this.businessFacadeWrapper.deleteById(this.entityClass(), shardingInfo, id);
    }

    @Override
    public Integer deleteBatch(ShardingInfo shardingInfo, List<Long> ids) {
        return this.businessFacadeWrapper.deleteBatch(this.entityClass(), shardingInfo, ids);
    }

    @Override
    public Integer deleteOneByKeys(ShardingInfo shardingInfo, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.deleteOneByKeys(this.entityClass(), shardingInfo, keyValues);
    }

    @Override
    public Integer deleteByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.deleteByCondition(this.entityClass(), shardingInfo, request);
    }

    @Override
    public Integer deleteByCondition(ShardingInfo shardingInfo, ExpQuery query) {
        return this.businessFacadeWrapper.deleteByCondition(this.entityClass(), shardingInfo, query);
    }

    @Override
    public Integer deleteBatchByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.deleteBatchByCondition(this.entityClass(), shardingInfo, request);
    }

    @Override
    public Integer deleteBatchByCondition(ShardingInfo shardingInfo, ExpQuery query) {
        return this.businessFacadeWrapper.deleteBatchByCondition(this.entityClass(), shardingInfo, query);
    }

    @Override
    public Integer updateById(ShardingInfo shardingInfo, T model) {
        return this.businessFacadeWrapper.updateById(this.entityClass(), shardingInfo, model);
    }

    @Override
    public Integer updateById(ShardingInfo shardingInfo, Map<String, Object> value, Long id) {
        return this.businessFacadeWrapper.updateById(this.entityClass(), shardingInfo, value, id);
    }

    @Override
    public Integer updateBatch(ShardingInfo shardingInfo, List<T> models) {
        return this.businessFacadeWrapper.updateBatch(this.entityClass(), shardingInfo, models);
    }

    @Override
    public Integer updateBatchMap(ShardingInfo shardingInfo, List<Map<String, Object>> values) {
        return this.businessFacadeWrapper.updateBatchMap(this.entityClass(), shardingInfo, values);
    }

    @Override
    public Integer updateByKeys(ShardingInfo shardingInfo, Map<String, Object> value, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.updateByKeys(this.entityClass(), shardingInfo, value, keyValues);
    }

    @Override
    public Integer updateByCondition(ShardingInfo shardingInfo, Map<String, Object> updateData, ConditionQueryRequest queryRequest) {
        return this.businessFacadeWrapper.updateByCondition(this.entityClass(), updateData, queryRequest);
    }

    @Override
    public List<T> findAllWithoutPageAndSort(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findAllWithoutPageAndSort(this.entityClass(), shardingInfo, this.targetClass, request);
    }

    @Override
    public List<T> findAllWithoutPageAndSort(ShardingInfo shardingInfo, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findAllWithoutPageAndSort(this.entityClass(), shardingInfo, this.targetClass, expQuery);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findAllMapWithoutPageAndSort(this.entityClass(), shardingInfo, request);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(ShardingInfo shardingInfo, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findAllMapWithoutPageAndSort(this.entityClass(), shardingInfo, expQuery);
    }

    @Override
    public Page<T> findPageByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findPageByCondition(this.entityClass(), shardingInfo, this.targetClass, ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    public Page<T> findPageByCondition(ShardingInfo shardingInfo, ExpQuery query) {
        return this.businessFacadeWrapper.findPageByCondition(this.entityClass(), shardingInfo, this.targetClass, query);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findPageMapByCondition(this.entityClass(), shardingInfo, request);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(ShardingInfo shardingInfo, ExpQuery query) {
        return this.businessFacadeWrapper.findPageMapByCondition(this.entityClass(), shardingInfo, query);
    }

    @Override
    public List<T> findByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findByCondition(this.entityClass(), shardingInfo, this.targetClass, request);
    }

    @Override
    public List<T> findByCondition(ShardingInfo shardingInfo, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findByCondition(this.entityClass(), shardingInfo, this.targetClass, expQuery);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findByConditionMap(this.entityClass(), shardingInfo, request);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(ShardingInfo shardingInfo, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findByConditionMap(this.entityClass(), shardingInfo, expQuery);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(ShardingInfo shardingInfo, IEntityClass entityClass, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findCollectionMapByCondition(entityClass, shardingInfo, request);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(ShardingInfo shardingInfo, IEntityClass entityClass, ExpRel expRel) {
        return this.businessFacadeWrapper.findCollectionMapByCondition(entityClass, shardingInfo, expRel);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByIds(ShardingInfo shardingInfo, IEntityClass entityClass, List<Long> ids) {
        return this.businessFacadeWrapper.findCollectionMapByIds(entityClass, shardingInfo, ids);
    }

    @Override
    public T findOneById(ShardingInfo shardingInfo, Long id) {
        return this.businessFacadeWrapper.findOneById(this.entityClass(), shardingInfo, this.targetClass, id);
    }

    @Override
    public Map<String, Object> findOneMapById(ShardingInfo shardingInfo, Long id) {
        return this.businessFacadeWrapper.findOneMapById(this.entityClass(), shardingInfo, id);
    }

    @Override
    public T findOneByKeys(ShardingInfo shardingInfo, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.findOneByKeys(this.entityClass(), shardingInfo, this.targetClass, keyValues);
    }

    @Override
    public Map<String, Object> findOneMapByKeys(ShardingInfo shardingInfo, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.findOneMapByKeys(this.entityClass(), shardingInfo, keyValues);
    }
}

