/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.advice;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.xforceplus.general.alarm.service.AlarmService;
import com.xforceplus.general.starter.logger.TraceContext;
import com.xforceplus.general.ultraman.configuration.UltramanStoreProperties;
import com.xforceplus.general.ultraman.converter.Converter;
import com.xforceplus.general.ultraman.domain.UltramanLog;
import com.xforceplus.general.ultraman.domain.vo.TenantInfo;
import com.xforceplus.general.ultraman.exception.UltramanException;
import com.xforceplus.general.ultraman.sharding.ShardingInfo;
import com.xforceplus.general.utils.json.JsonUtil;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.UltramanLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.core.model.setting.XlogUltramanSetting;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import io.prometheus.client.Summary;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataStorageAdvice {
    private static final Logger log = LoggerFactory.getLogger(DataStorageAdvice.class);
    private final AlarmService alarmService;
    private final UltramanStoreProperties ultramanStoreProperties;
    private final Optional<XlogProperties> xlogProperties;
    private final Optional<XlogSettings> xlogSettings;
    private final Optional<LogSender> logSender;
    private final ContextService contextService;
    private final Converter converter;
    @Qualifier(value="ultramanSummary")
    private final Summary ultramanSummary;

    @Pointcut(value="@annotation(com.xforceplus.general.ultraman.log.UltramanLog)")
    public void logCut() {
    }

    private String getEntityClassCode(Method method, Object entity) {
        Preconditions.checkArgument((boolean)(entity instanceof IEntityClass), (Object)String.format("%s first param must be of IEntityClass type", method.getName()));
        IEntityClass entityClass = (IEntityClass)entity;
        return Optional.ofNullable(entityClass).map(IEntityClass::code).orElse("");
    }

    private String getShardingInfo(Method method, Object paramSecond) {
        Preconditions.checkArgument((boolean)(paramSecond instanceof ShardingInfo), (Object)String.format("%s second param must be of ShardingInfo type", method.getName()));
        ShardingInfo shardingInfo = (ShardingInfo)paramSecond;
        return Optional.of(shardingInfo).map(ShardingInfo::getShardingInfo).orElseThrow(() -> new IllegalArgumentException("ShardingInfo is null"));
    }

    private boolean isShardingInfo(Method method, Object paramSecond) {
        return paramSecond instanceof ShardingInfo;
    }

    @Around(value="logCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = joinPoint.getTarget().getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        String methodName = method.getName();
        Object[] params = joinPoint.getArgs();
        String entityCode = this.getEntityClassCode(method, params[0]);
        String preTenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        boolean isSharding = this.isShardingInfo(method, params[1]);
        boolean isChangeContext = false;
        if (isSharding) {
            String shardingInfo = this.getShardingInfo(method, params[1]);
            isChangeContext = BooleanUtils.negate((Boolean)StringUtils.equals((CharSequence)preTenantCode, (CharSequence)shardingInfo));
            if (isChangeContext) {
                this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)shardingInfo);
            }
        } else if (StringUtils.isBlank((CharSequence)preTenantCode)) {
            log.warn("\u4e0a\u4e0b\u6587\u4e2d\u6ca1\u6709TENANTCODE_KEY\uff0centityCode:{},method:{}", (Object)entityCode, (Object)methodName);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        UltramanLog ultramanLog = this.createUltramanLog(method, params, entityCode);
        Object result = null;
        try {
            result = joinPoint.proceed();
            ultramanLog.setResponseText(JsonUtil.toJsonString((Object)result));
            ultramanLog.setResponseSize(ultramanLog.getResponseText().getBytes(StandardCharsets.UTF_8).length);
            ultramanLog.setSuccessful(true);
        }
        catch (Exception e) {
            log.error("ultraman error,method:" + methodName, (Throwable)e);
            this.alarmService.alarm(TraceContext.getPlusTraceId(), (Throwable)e, new Object[]{methodName, params});
            ultramanLog.setThrowable(e);
            ultramanLog.setSuccessful(false);
            throw new UltramanException(methodName + "\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        finally {
            if (isChangeContext) {
                if (StringUtils.isNotBlank((CharSequence)preTenantCode)) {
                    this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, (Object)preTenantCode);
                } else {
                    this.contextService.getAll().remove(ContextKeys.StringKeys.TENANTCODE_KEY.name());
                }
            }
            this.record(entityCode, stopwatch, ultramanLog, preTenantCode);
        }
        return result;
    }

    private UltramanLog createUltramanLog(Method method, Object[] params, String entityCode) {
        UltramanLog ultramanLog = new UltramanLog();
        ultramanLog.setParams(params);
        Object[] logParams = ArrayUtils.subarray((Object[])params, (int)1, (int)params.length);
        ultramanLog.setRequestText(JsonUtil.toJsonString((Object)logParams));
        ultramanLog.setRequestSize(ultramanLog.getRequestText().getBytes(StandardCharsets.UTF_8).length);
        String methodName = (String)StringUtils.defaultIfBlank((CharSequence)method.getAnnotation(com.xforceplus.general.ultraman.log.UltramanLog.class).method(), (CharSequence)method.getName());
        ultramanLog.setMethod(methodName);
        ultramanLog.setEntityCode(entityCode);
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        String userName = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME);
        TenantInfo tenantInfo = new TenantInfo();
        tenantInfo.setTenantId(tenantId);
        tenantInfo.setTenantCode(tenantCode);
        tenantInfo.setUsername(userName);
        ultramanLog.setTenantInfo(tenantInfo);
        return ultramanLog;
    }

    private UltramanLogEvent createUltramanLogEvent(UltramanLog ultramanLog, String preTenantCode) {
        UltramanLogEvent ultramanLogEvent = this.converter.convert(ultramanLog);
        if (this.xlogSettings.map(XlogSettings::getUltraman).map(XlogUltramanSetting::isIgnoreRequestText).orElse(false).booleanValue()) {
            ultramanLogEvent.setRequestText(null);
        }
        if (this.xlogSettings.map(XlogSettings::getUltraman).map(XlogUltramanSetting::isIgnoreResponseText).orElse(false).booleanValue()) {
            ultramanLogEvent.setResponseText(null);
        }
        ultramanLogEvent.setName(ultramanLog.getMethod() + ":" + ultramanLog.getEntityCode());
        if (ultramanLog.getMethod().endsWith("OnlyLog")) {
            ultramanLogEvent.setExtValue("forLog", (Object)true);
            Object[] params = ultramanLog.getParams();
            Object[] logAttachments = (Object[])params[params.length - 1];
            for (int i = 0; i < logAttachments.length; i += 2) {
                ultramanLogEvent.setExtValue(String.valueOf(logAttachments[i]), logAttachments[i + 1]);
            }
        }
        ultramanLogEvent.setStoreName(this.xlogProperties.map(XlogProperties::getStoreName).orElse(""));
        ultramanLogEvent.setType("Ultraman");
        ultramanLogEvent.setTraceId(LogContext.getTraceId());
        ultramanLogEvent.setExtValue("preTenantCode", (Object)preTenantCode);
        ultramanLogEvent.setExtValue("isMultiTenant", (Object)(!StringUtils.equals((CharSequence)preTenantCode, (CharSequence)ultramanLog.getTenantInfo().getTenantCode()) ? 1 : 0));
        return ultramanLogEvent;
    }

    private void record(String entityCode, Stopwatch stopwatch, UltramanLog ultramanLog, String preTenantCode) {
        this.printLog(ultramanLog, stopwatch, preTenantCode);
        if (this.xlogProperties.map(p -> p.getUltraman().isEnabled()).orElse(false).booleanValue()) {
            this.logSender.ifPresent(s -> s.send((LogEvent)this.createUltramanLogEvent(ultramanLog, preTenantCode)));
        }
        try {
            long cost = stopwatch.elapsed().toMillis();
            ((Summary.Child)this.ultramanSummary.labels(new String[]{ultramanLog.getMethod()})).observe((double)cost);
        }
        catch (Exception e) {
            log.error("uploadOqsInfo error entityClass[{}][{}] {}", new Object[]{entityCode, ultramanLog.getMethod(), e.getMessage(), e});
        }
    }

    private void printLog(UltramanLog ultramanLog, Stopwatch stopwatch, String preTenantCode) {
        if (!this.ultramanStoreProperties.isLogEnabled()) {
            return;
        }
        Long userId = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ID);
        String parameters = "nonlog";
        if (this.ultramanStoreProperties.isLogRequestEnabled()) {
            parameters = ultramanLog.getRequestText();
        }
        String result = "nonlog";
        if (this.ultramanStoreProperties.isLogResponseEnabled()) {
            result = ultramanLog.getResponseText();
        }
        log.info("ultraman log method:{},entity:{},userName:{},userId:{},tenantId:{},tenantCode:{},preTenantCode:{},duration:{},params:\u3010{}\u3011,result:\u3010{}\u3011,success:{}", new Object[]{ultramanLog.getMethod(), ultramanLog.getEntityCode(), ultramanLog.getTenantInfo().getUsername(), userId, ultramanLog.getTenantInfo().getTenantId(), ultramanLog.getTenantInfo().getTenantCode(), preTenantCode, stopwatch.toString(), parameters, result, ultramanLog.isSuccessful()});
    }

    public DataStorageAdvice(AlarmService alarmService, UltramanStoreProperties ultramanStoreProperties, Optional<XlogProperties> xlogProperties, Optional<XlogSettings> xlogSettings, Optional<LogSender> logSender, ContextService contextService, Converter converter, @Qualifier(value="ultramanSummary") Summary ultramanSummary) {
        this.alarmService = alarmService;
        this.ultramanStoreProperties = ultramanStoreProperties;
        this.xlogProperties = xlogProperties;
        this.xlogSettings = xlogSettings;
        this.logSender = logSender;
        this.contextService = contextService;
        this.converter = converter;
        this.ultramanSummary = ultramanSummary;
    }
}

