/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.store;

import com.google.common.base.CaseFormat;
import com.xforceplus.general.ultraman.DataStoreFacade;
import com.xforceplus.general.ultraman.sharding.ShardingInfo;
import com.xforceplus.general.ultraman.store.UltramanDataStoreFacadeWrapper;
import com.xforceplus.ultraman.extensions.business.service.QueryConfig;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.domain.vo.Page;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import io.vavr.Tuple2;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractDataStoreAdapter<T>
implements DataStoreFacade<T>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataStoreAdapter.class);
    private ApplicationContext context;
    private UltramanDataStoreFacadeWrapper businessFacadeWrapper;
    private String entityCode;
    private Class<T> targetClass;

    public AbstractDataStoreAdapter() {
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.targetClass = (Class)pt.getActualTypeArguments()[0];
        this.entityCode = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.targetClass.getSimpleName());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        this.businessFacadeWrapper = (UltramanDataStoreFacadeWrapper)this.context.getBean(UltramanDataStoreFacadeWrapper.class);
    }

    @Override
    public Long countAll(String tenantCode) {
        return this.businessFacadeWrapper.countAll(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode));
    }

    @Override
    public Long count(String tenantCode, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.count(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), request);
    }

    @Override
    public Long countExplicitly(String tenantCode, ConditionQueryRequest request, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.countExplicitly(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), request, queryConfig);
    }

    @Override
    public Long countExplicitly(ShardingInfo shardingInfo, ConditionQueryRequest request, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.countExplicitly(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), request, queryConfig);
    }

    @Override
    public Long count(String tenantCode, ExpQuery query) {
        return this.businessFacadeWrapper.count(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), query);
    }

    @Override
    public Long countExplicitly(String tenantCode, ExpQuery query, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.countExplicitly(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), query, queryConfig);
    }

    @Override
    public Long countExplicitly(ShardingInfo shardingInfo, ExpQuery query, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.countExplicitly(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), query, queryConfig);
    }

    @Override
    public Long insert(String tenantCode, Map<String, Object> value) {
        return this.businessFacadeWrapper.insert(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), value);
    }

    @Override
    public Long insert(String tenantCode, T model) {
        return this.businessFacadeWrapper.insert(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), model);
    }

    @Override
    public Long insert(String tenantCode, T model, Map<String, Object> extValue) {
        return this.businessFacadeWrapper.insert(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), model, extValue);
    }

    @Override
    public Integer insertBatch(String tenantCode, List<T> models) {
        return this.businessFacadeWrapper.insertBatch(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), models);
    }

    @Override
    public Integer insertBatchMap(String tenantCode, List<Map<String, Object>> values) {
        return this.businessFacadeWrapper.insertBatchMap(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), values);
    }

    @Override
    public Integer deleteById(String tenantCode, Long id) {
        return this.businessFacadeWrapper.deleteById(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), id);
    }

    @Override
    public Integer deleteBatch(String tenantCode, List<Long> ids) {
        return this.businessFacadeWrapper.deleteBatch(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), ids);
    }

    @Override
    public Integer updateById(String tenantCode, T model) {
        return this.businessFacadeWrapper.updateById(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), model);
    }

    @Override
    public Integer updateById(String tenantCode, Map<String, Object> value, Long id) {
        return this.businessFacadeWrapper.updateById(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), value, id);
    }

    @Override
    public Integer updateBatch(String tenantCode, List<T> models) {
        return this.businessFacadeWrapper.updateBatch(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), models);
    }

    @Override
    public Integer updateBatchMap(String tenantCode, List<Map<String, Object>> values) {
        return this.businessFacadeWrapper.updateBatchMap(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), values);
    }

    @Override
    public Integer updateByKeys(String tenantCode, Map<String, Object> value, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.updateByKeys(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), value, keyValues);
    }

    @Override
    public List<T> findAllWithoutPageAndSort(String tenantCode, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findAllWithoutPageAndSort(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), this.targetClass, request);
    }

    @Override
    public List<T> findAllWithoutPageAndSort(String tenantCode, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findAllWithoutPageAndSort(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), this.targetClass, expQuery);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(String tenantCode, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findAllMapWithoutPageAndSort(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), request);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(String tenantCode, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findAllMapWithoutPageAndSort(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), expQuery);
    }

    @Override
    public Page<T> findPageByCondition(String tenantCode, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findPageByCondition(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), this.targetClass, ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    public Page<T> findPageByCondition(String tenantCode, ExpQuery query) {
        return this.businessFacadeWrapper.findPageByCondition(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), this.targetClass, query);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(String tenantCode, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findPageMapByCondition(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), request);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(String tenantCode, ExpQuery query) {
        return this.businessFacadeWrapper.findPageMapByCondition(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), query);
    }

    @Override
    public List<T> findByCondition(String tenantCode, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findByCondition(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), this.targetClass, request);
    }

    @Override
    public List<T> findByCondition(String tenantCode, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findByCondition(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), this.targetClass, expQuery);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(String tenantCode, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findByConditionMap(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), request);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(String tenantCode, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findByConditionMap(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), expQuery);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(String tenantCode, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findCollectionMapByCondition(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), request);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(String tenantCode, ExpRel expRel) {
        return this.businessFacadeWrapper.findCollectionMapByCondition(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), expRel);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByIds(String tenantCode, List<Long> ids) {
        return this.businessFacadeWrapper.findCollectionMapByIds(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), ids);
    }

    @Override
    public T findOneById(String tenantCode, Long id) {
        return this.businessFacadeWrapper.findOneById(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), this.targetClass, id);
    }

    @Override
    public Map<String, Object> findOneMapById(String tenantCode, Long id) {
        return this.businessFacadeWrapper.findOneMapById(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), id);
    }

    @Override
    public T findOneByKeys(String tenantCode, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.findOneByKeys(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), this.targetClass, keyValues);
    }

    @Override
    public Map<String, Object> findOneMapByKeys(String tenantCode, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.findOneMapByKeys(tenantCode, this.businessFacadeWrapper.load(this.entityCode, tenantCode), keyValues);
    }

    @Override
    public Long countAll(ShardingInfo shardingInfo) {
        return this.businessFacadeWrapper.countAll(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()));
    }

    @Override
    public Long count(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.count(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public Long count(ShardingInfo shardingInfo, ExpQuery query) {
        return this.businessFacadeWrapper.count(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), query);
    }

    @Override
    public Long insert(ShardingInfo shardingInfo, Map<String, Object> value) {
        return this.businessFacadeWrapper.insert(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), value);
    }

    @Override
    public Long insert(ShardingInfo shardingInfo, T model) {
        return this.businessFacadeWrapper.insert(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), model);
    }

    @Override
    public Long insert(ShardingInfo shardingInfo, T model, Map<String, Object> extValue) {
        return this.businessFacadeWrapper.insert(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), model, extValue);
    }

    @Override
    public Integer insertBatch(ShardingInfo shardingInfo, List<T> models) {
        return this.businessFacadeWrapper.insertBatch(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), models);
    }

    @Override
    public Integer insertBatchMap(ShardingInfo shardingInfo, List<Map<String, Object>> values) {
        return this.businessFacadeWrapper.insertBatchMap(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), values);
    }

    @Override
    public Integer deleteById(ShardingInfo shardingInfo, Long id) {
        return this.businessFacadeWrapper.deleteById(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), id);
    }

    @Override
    public Integer deleteBatch(ShardingInfo shardingInfo, List<Long> ids) {
        return this.businessFacadeWrapper.deleteBatch(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), ids);
    }

    @Override
    public Integer updateById(ShardingInfo shardingInfo, T model) {
        return this.businessFacadeWrapper.updateById(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), model);
    }

    @Override
    public Integer updateById(ShardingInfo shardingInfo, Map<String, Object> value, Long id) {
        return this.businessFacadeWrapper.updateById(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), value, id);
    }

    @Override
    public Integer updateBatch(ShardingInfo shardingInfo, List<T> models) {
        return this.businessFacadeWrapper.updateBatch(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), models);
    }

    @Override
    public Integer updateBatchMap(ShardingInfo shardingInfo, List<Map<String, Object>> values) {
        return this.businessFacadeWrapper.updateBatchMap(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), values);
    }

    @Override
    public Integer updateByKeys(ShardingInfo shardingInfo, Map<String, Object> value, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.updateByKeys(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), value, keyValues);
    }

    @Override
    public List<T> findAllWithoutPageAndSort(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findAllWithoutPageAndSort(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, request);
    }

    @Override
    public List<T> findAllWithoutPageAndSort(ShardingInfo shardingInfo, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findAllWithoutPageAndSort(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, expQuery);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findAllMapWithoutPageAndSort(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(ShardingInfo shardingInfo, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findAllMapWithoutPageAndSort(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), expQuery);
    }

    @Override
    public Page<T> findPageByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findPageByCondition(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    public Page<T> findPageByConditionExplicitly(ShardingInfo shardingInfo, ConditionQueryRequest request, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.findPageByConditionExplicitly(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, ExpFactory.createFrom((ConditionQueryRequest)request), queryConfig);
    }

    @Override
    public Page<T> findPageByCondition(ShardingInfo shardingInfo, ExpQuery query) {
        return this.businessFacadeWrapper.findPageByCondition(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, query);
    }

    @Override
    public Page<T> findPageByConditionExplicitly(ShardingInfo shardingInfo, ExpQuery query, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.findPageByConditionExplicitly(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, query, queryConfig);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findPageMapByCondition(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(ShardingInfo shardingInfo, ExpQuery query) {
        return this.businessFacadeWrapper.findPageMapByCondition(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), query);
    }

    @Override
    public List<T> findByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findByCondition(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, request);
    }

    @Override
    public List<T> findByConditionExplicitly(ShardingInfo shardingInfo, ConditionQueryRequest request, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.findByConditionExplicitly(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, request, queryConfig);
    }

    @Override
    public List<T> findByCondition(ShardingInfo shardingInfo, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findByCondition(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, expQuery);
    }

    @Override
    public List<T> findByConditionExplicitly(ShardingInfo shardingInfo, ExpQuery expQuery, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.findByConditionExplicitly(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, expQuery, queryConfig);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(ShardingInfo shardingInfo, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findByConditionMap(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public List<Map<String, Object>> findByConditionMapExplicitly(ShardingInfo shardingInfo, ConditionQueryRequest request, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.findByConditionMapExplicitly(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), request, queryConfig);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(ShardingInfo shardingInfo, ExpQuery expQuery) {
        return this.businessFacadeWrapper.findByConditionMap(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), expQuery);
    }

    @Override
    public List<Map<String, Object>> findByConditionMapExplicitly(ShardingInfo shardingInfo, ExpQuery expQuery, QueryConfig queryConfig) {
        return this.businessFacadeWrapper.findByConditionMapExplicitly(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), expQuery, queryConfig);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(ShardingInfo shardingInfo, IEntityClass entityClass, ConditionQueryRequest request) {
        return this.businessFacadeWrapper.findCollectionMapByCondition(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(ShardingInfo shardingInfo, IEntityClass entityClass, ExpRel expRel) {
        return this.businessFacadeWrapper.findCollectionMapByCondition(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), expRel);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByIds(ShardingInfo shardingInfo, IEntityClass entityClass, List<Long> ids) {
        return this.businessFacadeWrapper.findCollectionMapByIds(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), ids);
    }

    @Override
    public T findOneById(ShardingInfo shardingInfo, Long id) {
        return this.businessFacadeWrapper.findOneById(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, id);
    }

    @Override
    public Map<String, Object> findOneMapById(ShardingInfo shardingInfo, Long id) {
        return this.businessFacadeWrapper.findOneMapById(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), id);
    }

    @Override
    public T findOneByKeys(ShardingInfo shardingInfo, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.findOneByKeys(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), this.targetClass, keyValues);
    }

    @Override
    public Map<String, Object> findOneMapByKeys(ShardingInfo shardingInfo, Tuple2<String, Object> ... keyValues) {
        return this.businessFacadeWrapper.findOneMapByKeys(shardingInfo.getTenantCode(), this.businessFacadeWrapper.load(this.entityCode, shardingInfo.getTenantCode()), keyValues);
    }
}

