/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.ultraman.store;

import cn.hutool.core.util.ReflectUtil;
import com.google.common.collect.Lists;
import com.xforceplus.general.ultraman.configuration.UltramanStoreProperties;
import com.xforceplus.general.ultraman.log.UltramanLog;
import com.xforceplus.ultraman.extensions.business.EntityId;
import com.xforceplus.ultraman.extensions.business.EntityInstance;
import com.xforceplus.ultraman.extensions.business.EntityKey;
import com.xforceplus.ultraman.extensions.business.service.QueryConfig;
import com.xforceplus.ultraman.extensions.business.service.TenantAwareBusinessFacade;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.domain.vo.Page;
import com.xforceplus.ultraman.metadata.domain.vo.Summary;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.helper.RequestBuilder;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRange;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.stereotype.Component;

@Component
public class UltramanDataStoreFacadeWrapper {
    private final TenantAwareBusinessFacade tenantAwareBusinessFacade;
    private final UltramanStoreProperties ultramanStoreProperties;

    @UltramanLog(method="countAlL")
    public Long countAll(String tenantCode, IEntityClass entityClass) {
        return this.tenantAwareBusinessFacade.countAll(tenantCode, entityClass);
    }

    @UltramanLog
    public Long count(String tenantCode, IEntityClass entityClass, ConditionQueryRequest request) {
        return this.tenantAwareBusinessFacade.count(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @UltramanLog(method="countExplicitly")
    public Long countExplicitly(String tenantCode, IEntityClass entityClass, ConditionQueryRequest request, QueryConfig queryConfig) {
        return this.tenantAwareBusinessFacade.countExplicitly(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request), queryConfig);
    }

    @UltramanLog
    public Long count(String tenantCode, IEntityClass entityClass, ExpQuery query) {
        return this.tenantAwareBusinessFacade.count(tenantCode, entityClass, (ExpRel)query);
    }

    @UltramanLog(method="countExplicitly")
    public Long countExplicitly(String tenantCode, IEntityClass entityClass, ExpQuery query, QueryConfig queryConfig) {
        return this.tenantAwareBusinessFacade.countExplicitly(tenantCode, entityClass, (ExpRel)query, queryConfig);
    }

    @UltramanLog(method="create")
    public Long insert(String tenantCode, IEntityClass entityClass, Map<String, Object> value) {
        return this.tenantAwareBusinessFacade.create(tenantCode, entityClass, value);
    }

    @UltramanLog(method="create")
    public <T> Long insert(String tenantCode, IEntityClass entityClass, T model) {
        return this.insert(tenantCode, entityClass, model, null);
    }

    @UltramanLog(method="create")
    public <T> Long insert(String tenantCode, IEntityClass entityClass, T model, Map<String, Object> extValue) {
        Map<String, Object> values = this.toOqsMap(model);
        if (MapUtils.isNotEmpty(extValue)) {
            values.putAll(extValue);
        }
        return this.insert(tenantCode, entityClass, (T)values);
    }

    @UltramanLog(method="createMulti")
    public <T> Integer insertBatch(String tenantCode, IEntityClass entityClass, List<T> models) {
        List<Map<String, Object>> values = models.stream().map(this::toOqsMap).collect(Collectors.toList());
        return this.insertBatchMap(tenantCode, entityClass, values);
    }

    @UltramanLog(method="createMulti")
    public <T> Integer insertBatchMap(String tenantCode, IEntityClass entityClass, List<Map<String, Object>> values) {
        return this.tenantAwareBusinessFacade.createMulti(tenantCode, entityClass, values);
    }

    @UltramanLog(method="deleteOne")
    public Integer deleteById(String tenantCode, IEntityClass entityClass, Long id) {
        return this.tenantAwareBusinessFacade.deleteOne(tenantCode, EntityId.of((IEntityClass)entityClass, (long)id));
    }

    @UltramanLog(method="deleteMulti")
    public Integer deleteBatch(String tenantCode, IEntityClass entityClass, List<Long> ids) {
        return this.tenantAwareBusinessFacade.deleteMulti(tenantCode, ids.stream().map(id -> EntityId.of((IEntityClass)entityClass, (long)id)).collect(Collectors.toList()));
    }

    @UltramanLog(method="updateById")
    public <T> Integer updateById(String tenantCode, IEntityClass entityClass, T model) {
        Long identity = (Long)ReflectUtil.invoke(model, (String)"getId", (Object[])new Object[0]);
        return Optional.ofNullable(identity).map(id -> this.tenantAwareBusinessFacade.updateById(tenantCode, EntityId.of((IEntityClass)entityClass, (long)id), this.toOqsMap(model))).orElse(null);
    }

    @UltramanLog(method="updateById")
    public Integer updateById(String tenantCode, IEntityClass entityClass, Map<String, Object> updateData, Long id) {
        return this.tenantAwareBusinessFacade.updateById(tenantCode, EntityId.of((IEntityClass)entityClass, (long)id), updateData);
    }

    @UltramanLog(method="updateMulti")
    public <T> Integer updateBatch(String tenantCode, IEntityClass entityClass, List<T> models) {
        List dataList = models.stream().map(this::toOqsMap).collect(Collectors.toList());
        return this.tenantAwareBusinessFacade.updateMulti(tenantCode, entityClass, dataList);
    }

    @UltramanLog(method="updateMulti")
    public Integer updateBatchMap(String tenantCode, IEntityClass entityClass, List<Map<String, Object>> values) {
        List dataList = values.stream().filter(v -> MapUtils.getLong((Map)v, (Object)"id") != null).collect(Collectors.toList());
        return this.tenantAwareBusinessFacade.updateMulti(tenantCode, entityClass, dataList);
    }

    @UltramanLog(method="updateByKey")
    public Integer updateByKeys(String tenantCode, IEntityClass entityClass, Map<String, Object> updateData, Tuple2<String, Object> ... conditionKeyValues) {
        return this.tenantAwareBusinessFacade.updateByKey(tenantCode, EntityKey.of((IEntityClass)entityClass, conditionKeyValues), updateData);
    }

    @UltramanLog(method="findAll")
    public <T> List<T> findAllWithoutPageAndSort(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, ConditionQueryRequest request) {
        Iterator instanceIterator = this.tenantAwareBusinessFacade.findAll(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(this.fromOqsMap(entityClazz, instance.getRecord().toMap(null)));
        }
        return dataList;
    }

    @UltramanLog(method="findAll")
    public <T> List<T> findAllWithoutPageAndSort(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, ExpQuery expQuery) {
        Iterator instanceIterator = this.tenantAwareBusinessFacade.findAll(tenantCode, entityClass, (ExpRel)expQuery);
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(this.fromOqsMap(entityClazz, instance.getRecord().toMap(null)));
        }
        return dataList;
    }

    @UltramanLog(method="findAll")
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(String tenantCode, IEntityClass entityClass, ConditionQueryRequest request) {
        Iterator instanceIterator = this.tenantAwareBusinessFacade.findAll(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(instance.getRecord().toMap(null));
        }
        return dataList;
    }

    @UltramanLog(method="findAll")
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(String tenantCode, IEntityClass entityClass, ExpQuery expQuery) {
        Iterator instanceIterator = this.tenantAwareBusinessFacade.findAll(tenantCode, entityClass, (ExpRel)expQuery);
        ArrayList dataList = Lists.newArrayList();
        while (instanceIterator.hasNext()) {
            EntityInstance instance = (EntityInstance)instanceIterator.next();
            dataList.add(instance.getRecord().toMap(null));
        }
        return dataList;
    }

    @UltramanLog(method="findByCondition")
    public Page<T> findPageByCondition(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, ConditionQueryRequest request) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> (T)this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList()), summary, (long)request.getPageSize().intValue(), (long)request.getPageNo().intValue());
    }

    @UltramanLog(method="findByCondition")
    public <T> Page<T> findPageByCondition(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, ExpQuery query) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)this.defaultPageIfNull(query));
        ExpRange range = query.getRange();
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList()), summary, (long)range.getIndex().intValue(), (long)range.getSize().intValue());
    }

    @UltramanLog(method="findByConditionExplicitly")
    public <T> Page<T> findPageByConditionExplicitly(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, ExpQuery query, QueryConfig queryConfig) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByConditionExplicitly(tenantCode, entityClass, (ExpRel)this.defaultPageIfNull(query), queryConfig);
        ExpRange range = query.getRange();
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList()), summary, (long)range.getIndex().intValue(), (long)range.getSize().intValue());
    }

    @UltramanLog(method="findByCondition")
    public Page<Map<String, Object>> findPageMapByCondition(String tenantCode, IEntityClass entityClass, ConditionQueryRequest request) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()), summary, (long)request.getPageSize().intValue(), (long)request.getPageNo().intValue());
    }

    @UltramanLog(method="findByCondition")
    public Page<Map<String, Object>> findPageMapByCondition(String tenantCode, IEntityClass entityClass, ExpQuery query) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)this.defaultPageIfNull(query));
        ExpRange range = query.getRange();
        Summary summary = new Summary();
        summary.setTotal((long)instanceIterator.getRowNum().intValue());
        return new Page(instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()), summary, (long)range.getIndex().intValue(), (long)range.getSize().intValue());
    }

    @UltramanLog(method="findByCondition")
    public <T> List<T> findByCondition(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, ConditionQueryRequest request) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        return instanceIterator.getRows().stream().map(a -> this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList());
    }

    @UltramanLog(method="findByConditionExplicitly")
    public <T> List<T> findByConditionExplicitly(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, ConditionQueryRequest request, QueryConfig queryConfig) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByConditionExplicitly(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)), queryConfig);
        return instanceIterator.getRows().stream().map(a -> this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList());
    }

    @UltramanLog(method="findByCondition")
    public <T> List<T> findByCondition(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, ExpQuery expQuery) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)this.defaultPageIfNull(expQuery));
        return instanceIterator.getRows().stream().map(a -> this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList());
    }

    @UltramanLog(method="findByConditionExplicitly")
    public <T> List<T> findByConditionExplicitly(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, ExpQuery expQuery, QueryConfig queryConfig) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByConditionExplicitly(tenantCode, entityClass, (ExpRel)this.defaultPageIfNull(expQuery), queryConfig);
        return instanceIterator.getRows().stream().map(a -> this.fromOqsMap(entityClazz, a.getRecord().toMap(null))).collect(Collectors.toList());
    }

    @UltramanLog(method="findByCondition")
    public List<Map<String, Object>> findByConditionMap(String tenantCode, IEntityClass entityClass, ConditionQueryRequest request) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        return instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList());
    }

    @UltramanLog(method="findByConditionExplicitly")
    public List<Map<String, Object>> findByConditionMapExplicitly(String tenantCode, IEntityClass entityClass, ConditionQueryRequest request, QueryConfig queryConfig) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByConditionExplicitly(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)), queryConfig);
        return instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList());
    }

    @UltramanLog(method="findByCondition")
    public List<Map<String, Object>> findByConditionMap(String tenantCode, IEntityClass entityClass, ExpQuery expQuery) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)this.defaultPageIfNull(expQuery));
        return instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList());
    }

    @UltramanLog(method="findByConditionExplicitly")
    public List<Map<String, Object>> findByConditionMapExplicitly(String tenantCode, IEntityClass entityClass, ExpQuery expQuery, QueryConfig queryConfig) {
        DataCollection instanceIterator = this.tenantAwareBusinessFacade.findByConditionExplicitly(tenantCode, entityClass, (ExpRel)this.defaultPageIfNull(expQuery), queryConfig);
        return instanceIterator.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList());
    }

    @UltramanLog(method="findByCondition")
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(String tenantCode, IEntityClass entityClass, ConditionQueryRequest request) {
        DataCollection dataCollection = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)this.defaultPageIfNull(request)));
        return new DataCollection(dataCollection.getRowNum(), dataCollection.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()));
    }

    @UltramanLog(method="findByCondition")
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(String tenantCode, IEntityClass entityClass, ExpRel expRel) {
        DataCollection dataCollection = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)this.defaultPageIfNull((ExpQuery)expRel));
        return new DataCollection(dataCollection.getRowNum(), dataCollection.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()));
    }

    @UltramanLog(method="findByCondition")
    public DataCollection<Map<String, Object>> findCollectionMapByIds(String tenantCode, IEntityClass entityClass, List<Long> ids) {
        RequestBuilder builder = new RequestBuilder().field("id", ConditionOp.in, ids);
        builder.pageSize(Integer.valueOf(ids.size())).pageNo(Integer.valueOf(1));
        DataCollection dataCollection = this.tenantAwareBusinessFacade.findByCondition(tenantCode, entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)builder.build()));
        return new DataCollection(dataCollection.getRowNum(), dataCollection.getRows().stream().map(a -> a.getRecord().toMap(null)).collect(Collectors.toList()));
    }

    @UltramanLog(method="findOne")
    public <T> T findOneById(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, Long id) {
        return this.fromOqsMap(entityClazz, this.findOneMapById(tenantCode, entityClass, id));
    }

    @UltramanLog(method="findOne")
    public Map<String, Object> findOneMapById(String tenantCode, IEntityClass entityClass, Long id) {
        Optional instanceOptional = this.tenantAwareBusinessFacade.findOne(tenantCode, EntityId.of((IEntityClass)entityClass, (long)id));
        return instanceOptional.map(entityInstance -> entityInstance.getRecord().toMap(null)).orElse(null);
    }

    @UltramanLog(method="findOneByKey")
    public <T> T findOneByKeys(String tenantCode, IEntityClass entityClass, Class<T> entityClazz, Tuple2<String, Object> ... keyValues) {
        Optional instanceOptional = this.tenantAwareBusinessFacade.findOneByKey(tenantCode, EntityKey.of((IEntityClass)entityClass, keyValues));
        return instanceOptional.map(entityInstance -> this.fromOqsMap(entityClazz, entityInstance.getRecord().toMap(null))).orElse(null);
    }

    @UltramanLog(method="findOneByKey")
    public Map<String, Object> findOneMapByKeys(String tenantCode, IEntityClass entityClass, Tuple2<String, Object> ... keyValues) {
        Optional instanceOptional = this.tenantAwareBusinessFacade.findOneByKey(tenantCode, EntityKey.of((IEntityClass)entityClass, keyValues));
        return instanceOptional.map(entityInstance -> entityInstance.getRecord().toMap(null)).orElse(null);
    }

    private <T> T fromOqsMap(Class<T> entityClazz, Map<String, Object> map) {
        return (T)(MapUtils.isEmpty(map) ? null : ReflectUtil.invoke((Object)ReflectUtil.newInstance(entityClazz, (Object[])new Object[0]), (String)"fromOQSMap", (Object[])new Object[]{map}));
    }

    private <T> Map<String, Object> toOqsMap(T model) {
        return null == model ? Collections.emptyMap() : (Map)ReflectUtil.invoke(model, (String)"toOQSMap", (Object[])new Object[0]);
    }

    public IEntityClass load(String entityCode, String tenantCode) {
        return this.tenantAwareBusinessFacade.load(entityCode, tenantCode);
    }

    private ConditionQueryRequest defaultPageIfNull(ConditionQueryRequest request) {
        if (request.getPageNo() == null) {
            request.setPageNo(Integer.valueOf(1));
        }
        if (request.getPageSize() == null) {
            request.setPageSize(Integer.valueOf(this.ultramanStoreProperties.getDefaultPageSize()));
        }
        return request;
    }

    private ExpQuery defaultPageIfNull(ExpQuery query) {
        if (null == query.getRange()) {
            query.setRange(new ExpRange(Integer.valueOf(1), Integer.valueOf(this.ultramanStoreProperties.getDefaultPageSize())));
        }
        return query;
    }

    public UltramanDataStoreFacadeWrapper(TenantAwareBusinessFacade tenantAwareBusinessFacade, UltramanStoreProperties ultramanStoreProperties) {
        this.tenantAwareBusinessFacade = tenantAwareBusinessFacade;
        this.ultramanStoreProperties = ultramanStoreProperties;
    }
}

