package com.xforceplus.general.ultraman;


import com.xforceplus.general.ultraman.sharding.ShardingInfo;
import com.xforceplus.ultraman.extensions.business.service.QueryConfig;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.domain.vo.Page;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import io.vavr.Tuple2;
import java.util.List;
import java.util.Map;

/**
 * purchaser-invoice-service 数据仓储
 *
 * @author MrYe
 * @date 2022-04-20 20:26
 */
public interface DataStoreFacade<T> {

    /**
     * 返回计数 无条件
     *
     * @return 条数
     */
    Long countAll(final String tenantCode);

    /**
     * 返回计数 有条件
     *
     * @param request 数据
     * @return 条数
     */
    Long count(final String tenantCode, ConditionQueryRequest request);

    /**
     * 返回计数 有条件
     *
     * @param request 数据
     * @return 条数
     */
    Long countExplicitly(final String tenantCode, ConditionQueryRequest request, final QueryConfig queryConfig);

    Long countExplicitly(final ShardingInfo shardingInfo, ConditionQueryRequest request, final QueryConfig queryConfig);

    /**
     * 查询条数
     *
     * @param query 支持Or的条件
     * @return 条数
     */
    Long count(final String tenantCode, ExpQuery query);

    /**
     * 查询条数
     *
     * @param query 支持Or的条件
     * @return 条数
     */
    Long countExplicitly(final String tenantCode, ExpQuery query, final QueryConfig queryConfig);

    Long countExplicitly(final ShardingInfo shardingInfo, ExpQuery query, final QueryConfig queryConfig);

    /**
     * 根据元数据对象结构创建一条数据实例，如果成功返回long值为唯一主键id 当传入了id字段时 返回的主键会以传入值为准
     *
     * @param value 数据
     * @return 唯一主键
     */
    Long insert(final String tenantCode, Map<String, Object> value);

    /**
     * 插入一条数据
     *
     * @param model 奥特曼对象实体
     * @return 唯一主键
     */
    Long insert(final String tenantCode, T model);

    /**
     * 插入一条数据，外键字段对象里没有时使用
     *
     * @param model    奥特曼对象实体
     * @param extValue 扩展字段
     * @return 唯一主键
     */
    Long insert(final String tenantCode, T model, Map<String, Object> extValue);

    /**
     * 插入一批数据
     *
     * @param models 奥特曼对象实体
     * @return 条数
     */
    Integer insertBatch(final String tenantCode, List<T> models);

    /**
     * 根据元数据对象结构创建多条数据实例，如果成功返回创建成功的数量
     *
     * @param values 数据
     * @return 条数
     */
    Integer insertBatchMap(final String tenantCode, List<Map<String, Object>> values);

    /**
     * 基于ID删除一条记录
     *
     * @param id 主键
     * @return 条数
     */
    Integer deleteById(final String tenantCode, Long id);

    /**
     * 基于多条ID批量删除
     *
     * @param ids 主键集合
     * @return 条数
     */
    Integer deleteBatch(final String tenantCode, List<Long> ids);

    /**
     * 基于ID更新
     *
     * @param model 对象实体
     * @return 条数
     */
    Integer updateById(final String tenantCode, T model);

    /**
     * 基于ID更新
     *
     * @param value 数据
     * @param id    主键
     * @return 条数
     */
    Integer updateById(final String tenantCode, Map<String, Object> value, Long id);

    /**
     * 基于ID批量更新
     *
     * @param models 对象实体
     * @return 条数
     */
    Integer updateBatch(final String tenantCode, List<T> models);

    /**
     * 基于ID批量更新
     *
     * @param values 集合数据
     * @return 行数
     */
    Integer updateBatchMap(final String tenantCode, List<Map<String, Object>> values);

    /**
     * 根据keyValues更新 key和value条件是equals
     *
     * @param value     数据
     * @param keyValues 条件
     * @return 条数
     */
    Integer updateByKeys(final String tenantCode, Map<String, Object> value, Tuple2<String, Object>... keyValues);

    /**
     * 查询所有数据，search after 实现可以突破数量限制，无排序
     *
     * @param request 条件
     * @return 结果
     */
    List<T> findAllWithoutPageAndSort(final String tenantCode, ConditionQueryRequest request);

    /**
     * 查询所有数据，search after 实现可以突破数量限制，无排序
     *
     * @param expQuery 支持Or的条件
     * @return 结果
     */
    List<T> findAllWithoutPageAndSort(final String tenantCode, ExpQuery expQuery);

    /**
     * 查询所有数据，search after 实现可以突破数量限制，无排序
     *
     * @param request 条件
     * @return 结果
     */
    List<Map<String, Object>> findAllMapWithoutPageAndSort(final String tenantCode, ConditionQueryRequest request);

    /**
     * 查询所有数据，search after 实现可以突破数量限制，无排序
     *
     * @param expQuery 支持Or的条件
     * @return 结果
     */
    List<Map<String, Object>> findAllMapWithoutPageAndSort(final String tenantCode, ExpQuery expQuery);

    /**
     * 基于条件查询,支持分页
     *
     * @param request 条件
     * @return 含分页信息集合
     */
    Page<T> findPageByCondition(final String tenantCode, ConditionQueryRequest request);

    /**
     * 基于条件查询,支持分页
     *
     * @param query 支持Or的条件
     * @return 含分页信息集合
     */
    Page<T> findPageByCondition(final String tenantCode, ExpQuery query);

    /**
     * 基于条件查询,支持分页
     *
     * @param request 条件
     * @return 含分页信息Map集合
     */
    Page<Map<String, Object>> findPageMapByCondition(final String tenantCode, ConditionQueryRequest request);

    /**
     * 基于条件查询,支持分页
     *
     * @param query 支持Or的条件
     * @return Map集合
     */
    Page<Map<String, Object>> findPageMapByCondition(final String tenantCode, ExpQuery query);

    /**
     * 基于条件查询,支持分页 Oqsengine中单对象配置默认是10000,关联对象的命中数据集不能超过默认2000
     *
     * @param request 条件
     * @return 实体集合
     */
    List<T> findByCondition(final String tenantCode, ConditionQueryRequest request);

    /**
     * 基于条件查询,支持分页 Oqsengine中单对象配置默认是10000,关联对象的命中数据集不能超过默认2000
     *
     * @param expQuery 支持Or的条件
     * @return 实体集合
     */
    List<T> findByCondition(final String tenantCode, ExpQuery expQuery);

    /**
     * 基于条件查询
     *
     * @param request 条件
     * @return Map集合
     */
    List<Map<String, Object>> findByConditionMap(final String tenantCode, ConditionQueryRequest request);

    /**
     * 基于 expQuery查询
     *
     * @param expQuery 可用于or查询场景
     * @return Map集合
     */
    List<Map<String, Object>> findByConditionMap(final String tenantCode, ExpQuery expQuery);

    DataCollection<Map<String, Object>> findCollectionMapByCondition(final String tenantCode, ConditionQueryRequest request);

    DataCollection<Map<String, Object>> findCollectionMapByCondition(final String tenantCode, final ExpRel expRel);

    DataCollection<Map<String, Object>> findCollectionMapByIds(final String tenantCode, List<Long> ids);

    /**
     * 基于ID查询一条数据
     *
     * @param id 主键
     * @return 结果
     */
    T findOneById(final String tenantCode, Long id);

    /**
     * 基于ID查询一条数据
     *
     * @param id 主键
     * @return 结果
     */
    Map<String, Object> findOneMapById(final String tenantCode, Long id);

    /**
     * 基于KeyValues查询一条数据
     *
     * @param keyValues 对象Class
     * @return 结果
     */
    T findOneByKeys(final String tenantCode, Tuple2<String, Object>... keyValues);

    /**
     * 基于KeyValues查询一条数据
     *
     * @param keyValues 对象Class
     * @return 结果
     */
    Map<String, Object> findOneMapByKeys(final String tenantCode, Tuple2<String, Object>... keyValues);

    /**
     * 返回计数 无条件
     *
     * @return 条数
     */
    Long countAll(ShardingInfo shardingInfo);

    /**
     * 返回计数 有条件
     *
     * @param request 数据
     * @return 条数
     */
    Long count(ShardingInfo shardingInfo, ConditionQueryRequest request);

    /**
     * 查询条数
     *
     * @param query 支持Or的条件
     * @return 条数
     */
    Long count(ShardingInfo shardingInfo, ExpQuery query);

    /**
     * 根据元数据对象结构创建一条数据实例，如果成功返回long值为唯一主键id 当传入了id字段时 返回的主键会以传入值为准
     *
     * @param value 数据
     * @return 唯一主键
     */
    Long insert(ShardingInfo shardingInfo, Map<String, Object> value);

    /**
     * 插入一条数据
     *
     * @param model 奥特曼对象实体
     * @return 唯一主键
     */
    Long insert(ShardingInfo shardingInfo, T model);

    /**
     * 插入一条数据，外键字段对象里没有时使用
     *
     * @param model    奥特曼对象实体
     * @param extValue 扩展字段
     * @return 唯一主键
     */
    Long insert(ShardingInfo shardingInfo, T model, Map<String, Object> extValue);

    /**
     * 插入一批数据
     *
     * @param models 奥特曼对象实体
     * @return 条数
     */
    Integer insertBatch(ShardingInfo shardingInfo, List<T> models);

    /**
     * 根据元数据对象结构创建多条数据实例，如果成功返回创建成功的数量
     *
     * @param values 数据
     * @return 条数
     */
    Integer insertBatchMap(ShardingInfo shardingInfo, List<Map<String, Object>> values);

    /**
     * 基于ID删除一条记录
     *
     * @param id 主键
     * @return 条数
     */
    Integer deleteById(ShardingInfo shardingInfo, Long id);

    /**
     * 基于多条ID批量删除
     *
     * @param ids 主键集合
     * @return 条数
     */
    Integer deleteBatch(ShardingInfo shardingInfo, List<Long> ids);

    /**
     * 根据keyValues删除 key和value条件是equals
     * todo 暂不支持
     * @param keyValues equals条件
     * @return 条数
     */
    //Integer deleteOneByKeys(ShardingInfo shardingInfo, Tuple2<String, Object>... keyValues);

    /**
     * 根据查询结果 多次单挑删除
     * todo 暂不支持
     * @param request 条件
     * @return 条数
     */
    //Integer deleteByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request);

    /**
     * 根据查询结果 多次单挑删除
     * todo 暂不支持
     * @param query 支持Or的条件
     * @return 条数
     */
    //Integer deleteByCondition(ShardingInfo shardingInfo, ExpQuery query);

    /**
     * 根据查询结果 批量删除
     * todo 暂不支持
     * @param request 条件
     * @return 条数
     */
    //Integer deleteBatchByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request);

    /**
     * 根据查询结果 批量删除
     * todo 暂不支持
     * @param query 支持Or的条件
     * @return 条数
     */
    //Integer deleteBatchByCondition(ShardingInfo shardingInfo, ExpQuery query);

    /**
     * 基于ID更新
     *
     * @param model 对象实体
     * @return 条数
     */
    Integer updateById(ShardingInfo shardingInfo, T model);

    /**
     * 基于ID更新
     *
     * @param value 数据
     * @param id    主键
     * @return 条数
     */
    Integer updateById(ShardingInfo shardingInfo, Map<String, Object> value, Long id);

    /**
     * 基于ID批量更新
     *
     * @param models 对象实体
     * @return 条数
     */
    Integer updateBatch(ShardingInfo shardingInfo, List<T> models);

    /**
     * 基于ID批量更新
     *
     * @param values 集合数据
     * @return 行数
     */
    Integer updateBatchMap(ShardingInfo shardingInfo, List<Map<String, Object>> values);

    /**
     * 根据keyValues更新 key和value条件是equals
     *
     * @param updateData 数据
     * @param keyValues  条件
     * @return 条数
     */
    Integer updateByKeys(ShardingInfo shardingInfo, Map<String, Object> updateData, Tuple2<String, Object>... keyValues);

    // todo 暂不支持
    //public Integer updateByCondition(final ShardingInfo shardingInfo, final Map<String, Object> updateData, final ConditionQueryRequest queryRequest);

    /**
     * 查询所有数据，search after 实现可以突破数量限制，无排序
     *
     * @param request 条件
     * @return 结果
     */
    List<T> findAllWithoutPageAndSort(ShardingInfo shardingInfo, ConditionQueryRequest request);

    /**
     * 查询所有数据，search after 实现可以突破数量限制，无排序
     *
     * @param expQuery 支持Or的条件
     * @return 结果
     */
    List<T> findAllWithoutPageAndSort(ShardingInfo shardingInfo, ExpQuery expQuery);

    /**
     * 查询所有数据，search after 实现可以突破数量限制，无排序
     *
     * @param request 条件
     * @return 结果
     */
    List<Map<String, Object>> findAllMapWithoutPageAndSort(ShardingInfo shardingInfo, ConditionQueryRequest request);

    /**
     * 基于条件查询,支持分页
     *
     * @param request 条件
     * @return 含分页信息集合
     */
    Page<T> findPageByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request);

    /**
     * 基于条件查询,支持分页,支持指定是否查询es
     *
     * @param request 支持Or的条件
     * @return 含分页信息集合
     */
    Page<T> findPageByConditionExplicitly(final ShardingInfo shardingInfo, final ConditionQueryRequest request, final QueryConfig queryConfig);

    /**
     * 基于条件查询,支持分页
     *
     * @param expQuery 支持Or的条件
     * @return 含分页信息集合
     */
    Page<T> findPageByCondition(ShardingInfo shardingInfo, ExpQuery expQuery);

    /**
     * 基于条件查询,支持分页,支持指定是否查询es
     *
     * @param expQuery 支持Or的条件
     * @return 含分页信息集合
     */
    Page<T> findPageByConditionExplicitly(final ShardingInfo shardingInfo, final ExpQuery expQuery, final QueryConfig queryConfig);


    List<Map<String, Object>> findAllMapWithoutPageAndSort(ShardingInfo shardingInfo, ExpQuery expQuery);

    /**
     * 基于条件查询,支持分页
     *
     * @param query 支持Or的条件
     * @return Map集合
     */
    Page<Map<String, Object>> findPageMapByCondition(ShardingInfo shardingInfo, ExpQuery query);

    Page<Map<String, Object>> findPageMapByCondition(ShardingInfo shardingInfo, ConditionQueryRequest request);


    /**
     * 基于条件查询,支持分页 Oqsengine中单对象配置默认是10000,关联对象的命中数据集不能超过默认2000
     *
     * @param request 条件
     * @return 实体集合
     */
    List<T> findByCondition(final ShardingInfo shardingInfo, ConditionQueryRequest request);


    /**
     * 基于条件查询,支持分页 Oqsengine中单对象配置默认是10000,关联对象的命中数据集不能超过默认2000 支持查询es
     *
     * @param request 条件
     * @return 实体集合
     */
    List<T> findByConditionExplicitly(final ShardingInfo shardingInfo, final ConditionQueryRequest request, final QueryConfig queryConfig);

    /**
     * 基于条件查询,支持分页 Oqsengine中单对象配置默认是10000,关联对象的命中数据集不能超过默认2000 支持查询es
     *
     * @param expQuery 支持Or的条件
     * @return 实体集合
     */
    List<T> findByCondition(ShardingInfo shardingInfo, ExpQuery expQuery);

    /**
     * 基于条件查询,支持分页 Oqsengine中单对象配置默认是10000,关联对象的命中数据集不能超过默认2000
     *
     * @param expQuery 支持Or的条件
     * @return 实体集合
     */
    List<T> findByConditionExplicitly(final ShardingInfo shardingInfo, final ExpQuery expQuery, final QueryConfig queryConfig);

    /**
     * 基于条件查询
     *
     * @param request 条件
     * @return Map集合
     */
    List<Map<String, Object>> findByConditionMap(ShardingInfo shardingInfo, ConditionQueryRequest request);

    /**
     * 基于条件查询 支持es
     *
     * @param request 条件
     * @return Map集合
     */
    List<Map<String, Object>> findByConditionMapExplicitly(final ShardingInfo shardingInfo, final ConditionQueryRequest request, final QueryConfig queryConfig);


    /**
     * 基于 expQuery查询
     *
     * @param expQuery 可用于or查询场景
     * @return Map集合
     */
    List<Map<String, Object>> findByConditionMap(ShardingInfo shardingInfo, ExpQuery expQuery);

    /**
     * 基于 expQuery查询 支持es
     *
     * @param expQuery 可用于or查询场景
     * @return Map集合
     */
    List<Map<String, Object>> findByConditionMapExplicitly(final ShardingInfo shardingInfo, final ExpQuery expQuery, final QueryConfig queryConfig);


    DataCollection<Map<String, Object>> findCollectionMapByCondition(ShardingInfo shardingInfo, IEntityClass entityClass, ConditionQueryRequest request);

    DataCollection<Map<String, Object>> findCollectionMapByCondition(ShardingInfo shardingInfo, IEntityClass entityClass, ExpRel expRel);


    DataCollection<Map<String, Object>> findCollectionMapByIds(ShardingInfo shardingInfo, IEntityClass entityClass, List<Long> ids);

    /**
     * 基于ID查询一条数据
     *
     * @param id 主键
     * @return 结果
     */
    T findOneById(ShardingInfo shardingInfo, Long id);

    /**
     * 基于ID查询一条数据
     *
     * @param id 主键
     * @return 结果
     */
    Map<String, Object> findOneMapById(ShardingInfo shardingInfo, Long id);

    /**
     * 基于KeyValues查询一条数据
     *
     * @param keyValues 对象Class
     * @return 结果
     */
    T findOneByKeys(ShardingInfo shardingInfo, Tuple2<String, Object>... keyValues);

    /**
     * 基于KeyValues查询一条数据
     *
     * @param keyValues 对象Class
     * @return 结果
     */
    Map<String, Object> findOneMapByKeys(ShardingInfo shardingInfo, Tuple2<String, Object>... keyValues);

}
