package com.xforceplus.general.ultraman.configuration;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.Summary;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/10/18 14:14
 */
@Configuration
@EnableConfigurationProperties(value = {UltramanStoreProperties.class})
@ComponentScan(basePackages = "com.xforceplus.general.ultraman")
public class UltramanAutoConfiguration {

    @Bean("ultramanSummary")
    public Summary oqsSummary(final PrometheusMeterRegistry prometheusMeterRegistry) {
        return Summary.build()
            .name("ultraman_summary").labelNames("method")
            .help("Ultraman Summary.").register(prometheusMeterRegistry.getPrometheusRegistry());
    }

}
