package com.xforceplus.general.ultraman.exception;

import org.apache.commons.lang3.StringUtils;

/**
 * monitoring-platform
 *
 * @author MrYe
 * @date 2022-10-26 17:31
 */
public class UltramanException extends RuntimeException {

    public UltramanException(final String format, final Object... objects) {
        formatMessage(format, objects);
    }

    private static String formatMessage(final String format, final Object[] objects) {
        final String formatStr = StringUtils.replace(format, "{}", "%s");
        return String.format(formatStr, objects);
    }

    public UltramanException(final String format, final Throwable throwable, final Object... objects) {
        super(formatMessage(format, objects), throwable);
    }

}
