package com.xforceplus.general.ultraman.log;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author zhuxingsheng@gmail.com
 * @description: 奥特曼方法注解，用于记录奥特曼耗时和异常监测
 * @date 2023/3/28 16:39
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface UltramanLog {

    /**
     * 奥特曼的原生方法名
     * <p>
     * 当包装的方法名与原生方法名相同，可以不用赋值
     *
     * @return
     */
    String method() default "";

}
