package com.xforceplus.general.ultraman.sharding;

import com.google.common.base.Preconditions;
import lombok.Builder;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/6/13 12:54
 */
@Builder
@Getter
public class ShardingInfo {

    private String tenantCode;

    private ShardingInfo(final String tenantCode) {
        this.tenantCode = tenantCode;
        Preconditions.checkArgument(StringUtils.isNoneBlank(tenantCode), "tenantCode为分库依据，不会为空");
    }

    public String getShardingInfo() {
        return tenantCode;
    }

}
