package com.xforceplus.general.ultraman.store;

import com.google.common.base.CaseFormat;
import com.xforceplus.general.ultraman.DataStoreFacade;
import com.xforceplus.general.ultraman.sharding.ShardingInfo;
import com.xforceplus.ultraman.extensions.business.service.QueryConfig;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.domain.vo.Page;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider.QueryProviderType;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import io.vavr.Tuple2;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * @author MrYe
 * @date 2022-04-20 20:27
 */
@Slf4j
public abstract class AbstractDataStoreAdapter<T> implements DataStoreFacade<T>, ApplicationContextAware {

    private ApplicationContext context;

    private UltramanDataStoreFacadeWrapper businessFacadeWrapper;
    private String entityCode;
    private Class<T> targetClass;

    public AbstractDataStoreAdapter() {
        final ParameterizedType pt = (ParameterizedType) getClass().getGenericSuperclass();
        targetClass = (Class<T>) pt.getActualTypeArguments()[0];
        entityCode = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, targetClass.getSimpleName());
    }

    @Override
    public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
        businessFacadeWrapper = context.getBean(UltramanDataStoreFacadeWrapper.class);
    }

    @Override
    public Long countAll(final String tenantCode) {
        return businessFacadeWrapper.countAll(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode));
    }


    @Override
    public Long count(final String tenantCode, final ConditionQueryRequest request) {
        return businessFacadeWrapper.count(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), request);
    }

    @Override
    public Long countExplicitly(final String tenantCode, final ConditionQueryRequest request, final QueryConfig queryConfig) {
        return businessFacadeWrapper.countExplicitly(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), request, queryConfig);
    }

    @Override
    public Long countExplicitly(final ShardingInfo shardingInfo, final ConditionQueryRequest request, final QueryConfig queryConfig) {
        return businessFacadeWrapper.countExplicitly(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), request, queryConfig);
    }

    @Override
    public Long count(final String tenantCode, final ExpQuery query) {
        return businessFacadeWrapper.count(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), query);
    }

    @Override
    public Long countExplicitly(final String tenantCode, final ExpQuery query, final QueryConfig queryConfig) {
        return businessFacadeWrapper.countExplicitly(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), query, queryConfig);
    }

    @Override
    public Long countExplicitly(final ShardingInfo shardingInfo, final ExpQuery query, final QueryConfig queryConfig) {
        return businessFacadeWrapper.countExplicitly(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), query, queryConfig);
    }

    @Override
    public Long insert(final String tenantCode, final Map<String, Object> value) {
        return businessFacadeWrapper.insert(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), value);
    }


    @Override
    public Long insert(final String tenantCode, final T model) {
        return businessFacadeWrapper.insert(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), model);
    }


    @Override
    public Long insert(final String tenantCode, final T model, final Map<String, Object> extValue) {
        return businessFacadeWrapper.insert(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), model, extValue);
    }


    @Override
    public Integer insertBatch(final String tenantCode, final List<T> models) {
        return businessFacadeWrapper.insertBatch(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), models);
    }


    @Override
    public Integer insertBatchMap(final String tenantCode, final List<Map<String, Object>> values) {
        return businessFacadeWrapper.insertBatchMap(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), values);
    }


    @Override
    public Integer deleteById(final String tenantCode, final Long id) {
        return businessFacadeWrapper.deleteById(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), id);
    }


    @Override
    public Integer deleteBatch(final String tenantCode, final List<Long> ids) {
        return businessFacadeWrapper.deleteBatch(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), ids);
    }

    @Override
    public Integer updateById(final String tenantCode, final T model) {
        return businessFacadeWrapper.updateById(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), model);
    }


    @Override
    public Integer updateById(final String tenantCode, final Map<String, Object> value, final Long id) {
        return businessFacadeWrapper.updateById(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), value, id);
    }


    @Override
    public Integer updateBatch(final String tenantCode, final List<T> models) {
        return businessFacadeWrapper.updateBatch(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), models);
    }


    @Override
    public Integer updateBatchMap(final String tenantCode, final List<Map<String, Object>> values) {
        return businessFacadeWrapper.updateBatchMap(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), values);
    }


    @Override
    public Integer updateByKeys(final String tenantCode, final Map<String, Object> value, final Tuple2<String, Object>... keyValues) {
        return businessFacadeWrapper.updateByKeys(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), value, keyValues);
    }


    @Override
    public List<T> findAllWithoutPageAndSort(final String tenantCode, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findAllWithoutPageAndSort(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), targetClass, request);
    }


    @Override
    public List<T> findAllWithoutPageAndSort(final String tenantCode, final ExpQuery expQuery) {
        return businessFacadeWrapper.findAllWithoutPageAndSort(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), targetClass, expQuery);
    }


    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(final String tenantCode, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findAllMapWithoutPageAndSort(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), request);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(final String tenantCode, final ExpQuery expQuery) {
        return businessFacadeWrapper.findAllMapWithoutPageAndSort(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), expQuery);
    }

    @Override
    public Page<T> findPageByCondition(final String tenantCode, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findPageByCondition(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), targetClass, ExpFactory.createFrom(request));
    }

    @Override
    public Page<T> findPageByCondition(final String tenantCode, final ExpQuery query) {
        return businessFacadeWrapper.findPageByCondition(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), targetClass, query);
    }


    @Override
    public Page<Map<String, Object>> findPageMapByCondition(final String tenantCode, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findPageMapByCondition(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), request);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(final String tenantCode, final ExpQuery query) {
        return businessFacadeWrapper.findPageMapByCondition(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), query);
    }

    @Override
    public List<T> findByCondition(final String tenantCode, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findByCondition(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), targetClass, request);
    }

    @Override
    public List<T> findByCondition(final String tenantCode, final ExpQuery expQuery) {
        return businessFacadeWrapper.findByCondition(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), targetClass, expQuery);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(final String tenantCode, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findByConditionMap(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), request);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(final String tenantCode, final ExpQuery expQuery) {
        return businessFacadeWrapper.findByConditionMap(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), expQuery);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(final String tenantCode, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findCollectionMapByCondition(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), request);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(final String tenantCode, final ExpRel expRel) {
        return businessFacadeWrapper.findCollectionMapByCondition(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), expRel);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByIds(final String tenantCode, final List<Long> ids) {
        return businessFacadeWrapper.findCollectionMapByIds(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), ids);
    }

    @Override
    public T findOneById(final String tenantCode, final Long id) {
        return businessFacadeWrapper.findOneById(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), targetClass, id);
    }


    @Override
    public Map<String, Object> findOneMapById(final String tenantCode, final Long id) {
        return businessFacadeWrapper.findOneMapById(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), id);
    }

    @Override
    public T findOneByKeys(final String tenantCode, final Tuple2<String, Object>... keyValues) {
        return businessFacadeWrapper.findOneByKeys(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), targetClass, keyValues);
    }

    @Override
    public Map<String, Object> findOneMapByKeys(final String tenantCode, final Tuple2<String, Object>... keyValues) {
        return businessFacadeWrapper.findOneMapByKeys(tenantCode, businessFacadeWrapper.load(entityCode, tenantCode), keyValues);
    }

    @Override
    public Long countAll(final ShardingInfo shardingInfo) {
        return businessFacadeWrapper.countAll(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()));
    }

    @Override
    public Long count(final ShardingInfo shardingInfo, final ConditionQueryRequest request) {
        return businessFacadeWrapper.count(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public Long count(final ShardingInfo shardingInfo, final ExpQuery query) {
        return businessFacadeWrapper.count(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), query);
    }


    @Override
    public Long insert(final ShardingInfo shardingInfo, final Map<String, Object> value) {
        return businessFacadeWrapper.insert(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), value);
    }

    @Override
    public Long insert(final ShardingInfo shardingInfo, final T model) {
        return businessFacadeWrapper.insert(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), model);
    }

    @Override
    public Long insert(final ShardingInfo shardingInfo, final T model, final Map<String, Object> extValue) {
        return businessFacadeWrapper.insert(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), model, extValue);
    }

    @Override
    public Integer insertBatch(final ShardingInfo shardingInfo, final List<T> models) {
        return businessFacadeWrapper.insertBatch(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), models);
    }

    @Override
    public Integer insertBatchMap(final ShardingInfo shardingInfo, final List<Map<String, Object>> values) {
        return businessFacadeWrapper.insertBatchMap(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), values);
    }

    @Override
    public Integer deleteById(final ShardingInfo shardingInfo, final Long id) {
        return businessFacadeWrapper.deleteById(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), id);
    }

    @Override
    public Integer deleteBatch(final ShardingInfo shardingInfo, final List<Long> ids) {
        return businessFacadeWrapper.deleteBatch(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), ids);
    }

   /* @Override
    public Integer deleteOneByKeys(final ShardingInfo shardingInfo, final Tuple2<String, Object>... keyValues) {
        return businessFacadeWrapper.deleteOneByKeys(entityClass(), shardingInfo, keyValues);
    }*/

    /*@Override
    public Integer deleteByCondition(final ShardingInfo shardingInfo, final ConditionQueryRequest request) {
        return businessFacadeWrapper.deleteByCondition(entityClass(), shardingInfo, request);
    }*/

    /*@Override
    public Integer deleteByCondition(final ShardingInfo shardingInfo, final ExpQuery query) {
        return businessFacadeWrapper.deleteByCondition(entityClass(), shardingInfo, query);
    }*/

    /*@Override
    public Integer deleteBatchByCondition(final ShardingInfo shardingInfo, final ConditionQueryRequest request) {
        return businessFacadeWrapper.deleteBatchByCondition(entityClass(), shardingInfo, request);
    }*/

    /*@Override
    public Integer deleteBatchByCondition(final ShardingInfo shardingInfo, final ExpQuery query) {
        return businessFacadeWrapper.deleteBatchByCondition(entityClass(), shardingInfo, query);
    }*/

    @Override
    public Integer updateById(final ShardingInfo shardingInfo, final T model) {
        return businessFacadeWrapper.updateById(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), model);
    }

    @Override
    public Integer updateById(final ShardingInfo shardingInfo, final Map<String, Object> value, final Long id) {
        return businessFacadeWrapper.updateById(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), value, id);
    }

    @Override
    public Integer updateBatch(final ShardingInfo shardingInfo, final List<T> models) {
        return businessFacadeWrapper.updateBatch(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), models);
    }

    @Override
    public Integer updateBatchMap(final ShardingInfo shardingInfo, final List<Map<String, Object>> values) {
        return businessFacadeWrapper.updateBatchMap(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), values);
    }

    @Override
    public Integer updateByKeys(final ShardingInfo shardingInfo, final Map<String, Object> value, final Tuple2<String, Object>... keyValues) {
        return businessFacadeWrapper.updateByKeys(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), value, keyValues);
    }

    /*@Override
    public Integer updateByCondition(final ShardingInfo shardingInfo, final Map<String, Object> updateData, final ConditionQueryRequest queryRequest) {
        return businessFacadeWrapper.updateByCondition(entityClass(), updateData, queryRequest);
    }*/

    @Override
    public List<T> findAllWithoutPageAndSort(final ShardingInfo shardingInfo, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findAllWithoutPageAndSort(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, request);
    }

    @Override
    public List<T> findAllWithoutPageAndSort(final ShardingInfo shardingInfo, final ExpQuery expQuery) {
        return businessFacadeWrapper.findAllWithoutPageAndSort(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, expQuery);
    }


    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(final ShardingInfo shardingInfo, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findAllMapWithoutPageAndSort(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public List<Map<String, Object>> findAllMapWithoutPageAndSort(final ShardingInfo shardingInfo, final ExpQuery expQuery) {
        return businessFacadeWrapper.findAllMapWithoutPageAndSort(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), expQuery);
    }

    @Override
    public Page<T> findPageByCondition(final ShardingInfo shardingInfo, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findPageByCondition(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass,
            ExpFactory.createFrom(request));
    }

    @Override
    public Page<T> findPageByConditionExplicitly(final ShardingInfo shardingInfo, final ConditionQueryRequest request, final QueryConfig queryConfig) {
        return businessFacadeWrapper.findPageByConditionExplicitly(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass,
            ExpFactory.createFrom(request), queryConfig);
    }

    @Override
    public Page<T> findPageByCondition(final ShardingInfo shardingInfo, final ExpQuery query) {
        return businessFacadeWrapper.findPageByCondition(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, query);
    }

    @Override
    public Page<T> findPageByConditionExplicitly(final ShardingInfo shardingInfo, final ExpQuery query, final QueryConfig queryConfig) {
        return businessFacadeWrapper.findPageByConditionExplicitly(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, query, queryConfig);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(final ShardingInfo shardingInfo, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findPageMapByCondition(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public Page<Map<String, Object>> findPageMapByCondition(final ShardingInfo shardingInfo, final ExpQuery query) {
        return businessFacadeWrapper.findPageMapByCondition(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), query);
    }

    @Override
    public List<T> findByCondition(final ShardingInfo shardingInfo, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findByCondition(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, request);
    }

    @Override
    public List<T> findByConditionExplicitly(final ShardingInfo shardingInfo, final ConditionQueryRequest request, final QueryConfig queryConfig) {
        return businessFacadeWrapper.findByConditionExplicitly(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, request, queryConfig);
    }

    @Override
    public List<T> findByCondition(final ShardingInfo shardingInfo, final ExpQuery expQuery) {
        return businessFacadeWrapper.findByCondition(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, expQuery);
    }

    @Override
    public List<T> findByConditionExplicitly(final ShardingInfo shardingInfo, final ExpQuery expQuery, final QueryConfig queryConfig) {
        return businessFacadeWrapper.findByConditionExplicitly(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, expQuery, queryConfig);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(final ShardingInfo shardingInfo, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findByConditionMap(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public List<Map<String, Object>> findByConditionMapExplicitly(final ShardingInfo shardingInfo, final ConditionQueryRequest request, final QueryConfig queryConfig) {
        return businessFacadeWrapper.findByConditionMapExplicitly(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), request, queryConfig);
    }

    @Override
    public List<Map<String, Object>> findByConditionMap(final ShardingInfo shardingInfo, final ExpQuery expQuery) {
        return businessFacadeWrapper.findByConditionMap(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), expQuery);
    }

    @Override
    public List<Map<String, Object>> findByConditionMapExplicitly(final ShardingInfo shardingInfo, final ExpQuery expQuery, final QueryConfig queryConfig) {
        return businessFacadeWrapper.findByConditionMapExplicitly(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), expQuery, queryConfig);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(final ShardingInfo shardingInfo, final IEntityClass entityClass, final ConditionQueryRequest request) {
        return businessFacadeWrapper.findCollectionMapByCondition(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), request);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByCondition(final ShardingInfo shardingInfo, final IEntityClass entityClass, final ExpRel expRel) {
        return businessFacadeWrapper.findCollectionMapByCondition(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), expRel);
    }

    @Override
    public DataCollection<Map<String, Object>> findCollectionMapByIds(final ShardingInfo shardingInfo, final IEntityClass entityClass, final List<Long> ids) {
        return businessFacadeWrapper.findCollectionMapByIds(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), ids);
    }


    @Override
    public T findOneById(final ShardingInfo shardingInfo, final Long id) {
        return businessFacadeWrapper.findOneById(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, id);
    }

    @Override
    public Map<String, Object> findOneMapById(final ShardingInfo shardingInfo, final Long id) {
        return businessFacadeWrapper.findOneMapById(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), id);
    }

    @Override
    public T findOneByKeys(final ShardingInfo shardingInfo, final Tuple2<String, Object>... keyValues) {
        return businessFacadeWrapper.findOneByKeys(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), targetClass, keyValues);
    }

    @Override
    public Map<String, Object> findOneMapByKeys(final ShardingInfo shardingInfo, final Tuple2<String, Object>... keyValues) {
        return businessFacadeWrapper.findOneMapByKeys(shardingInfo.getTenantCode(), businessFacadeWrapper.load(entityCode, shardingInfo.getTenantCode()), keyValues);
    }

}
