package com.xforceplus.general.ultraman.util;

import com.xforceplus.general.ultraman.constants.MultiOQSConstants;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Component;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/7/13 13:45
 */
@Component
@RequiredArgsConstructor
@Slf4j
public class MultiOQSUtil {

    /**
     * <pre>
     * 需要打开多租户开关才能获取到
     * #多租户
     * #xplat.oqsengine.sdk.dynamic.masterRouting[SC@vanke] = master1
     * </pre>
     */
    private final Optional<DynamicConfig> multiTenantConfigOptional;

    /**
     * 获取所有OQS的tenantCode
     *
     * @return
     */
    public Set<String> getMultiTenants() {
        final Set<String> tenantCodes = new HashSet<String>();
        //增加一个主库
        tenantCodes.add(MultiOQSConstants.OQS_MASTER);
        if (!multiTenantConfigOptional.isPresent()) {
            return tenantCodes;
        }
        MapUtils.emptyIfNull(multiTenantConfigOptional.get().getMasterRouting())
            .entrySet()
            .stream()
            .collect(Collectors.groupingBy(Entry::getValue))
            .forEach((key, value) -> tenantCodes.add(value.get(0).getKey()));
        return tenantCodes;
    }

}
