/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.utils;

import java.lang.reflect.AccessibleObject;

public class ReflectUtil {
    public static <T> T newInstance(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ReflectUtil.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ReflectUtil.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

