/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.utils.aop.aspects;

import com.xforceplus.general.utils.aop.aspects.SimpleAspect;
import com.xforceplus.general.utils.lang.SystemClock;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeIntervalAspect
extends SimpleAspect {
    private static final Logger log = LoggerFactory.getLogger(TimeIntervalAspect.class);
    private static final long serialVersionUID = 1L;
    private long start = 0L;

    @Override
    public boolean before(Object target, Method method, Object[] args) {
        this.start = SystemClock.now();
        return true;
    }

    @Override
    public boolean after(Object target, Method method, Object[] args, Object returnVal) {
        long interval = SystemClock.now() - this.start;
        log.info("Method [{}.{}] execute spend [{}]ms return value [{}]", new Object[]{target.getClass().getName(), method.getName(), interval, returnVal});
        return true;
    }
}

