package com.xforceplus.ant.im.server.client.api.alarm;

import com.xforceplus.ant.im.server.client.data.alarm.request.CreateInvoiceOperation;
import com.xforceplus.ant.im.server.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * Describe: 发票操作告警 API
 *
 * @Author xiezhongyong
 * @Date 2020-10-16
 */
@Api(value = "invoice-operation-alarm", description = "发票操作告警 接口服务")
public interface InvoiceOperationAlarmControllerApi {

    @ApiOperation("添加发票操作记录")
    @RequestMapping(value = "/invoice-operation-alarm", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateInvoiceOperation input);

}
