package com.xforceplus.ant.im.server.client.data.alarm.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * Describe: 发票操作vo
 *
 * @Author xiezhongyong
 * @Date 2020-10-16
 */
@Data
public class CreateInvoiceOperation {

    @ApiModelProperty("操作类型 insert/update")
    private String opType;

    @ApiModelProperty("数据ID")
    private Long id;

    @JsonProperty("tx_id")
    @ApiModelProperty("事务id，代表依次业务操作")
    private String txId;

    @JsonProperty("serial_no")
    @ApiModelProperty("流水号-发给税件和税件返回的都是它")
    private Long serialNo;

    @JsonProperty("business_id")
    @ApiModelProperty("业务主键")
    private Long businessId;

    @JsonProperty("operation_type")
    @ApiModelProperty("操作类型,0=开票，1=开票并打印，2=红冲，3=打印，4=作废，5=请求下一张发票号码，6-拆票，7-获取发票PDF")
    private Integer operationType;

    @JsonProperty("process_status")
    @ApiModelProperty("处理状态 1=发送失败，2=(外部)系统处理中，3=成功，4=失败")
    private Integer processStatus;

    @JsonProperty("process_remark")
    @ApiModelProperty("处理结果")
    private String processRemark;

    @JsonProperty("release_type")
    @ApiModelProperty("作废红冲释放类型1-释放预制发票 2-释放结算单 3-不释放 4-配置不释放 5-配置释放 6-红冲票作废释放标识")
    private Integer releaseType;

    @JsonProperty("terminal_type")
    @ApiModelProperty("终端类型 1-单盘 2-服务器")
    private Integer terminalType;

    @JsonProperty("business_data")
    @ApiModelProperty("业务数据")
    private String businessData;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JsonProperty("create_time")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JsonProperty("update_time")
    @ApiModelProperty("更新时间")
    private Date updateTime;

    @JsonProperty("operation_user_id")
    @ApiModelProperty("操作用户id")
    private Long operationUserId;

    @JsonProperty("operation_name")
    @ApiModelProperty("操作人")
    private String operationName;
}
