package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Api(value = "sellerPreInvoice", description = "the sellerPreInvoice API")
public interface SellerPreInvoiceApi {

    @ApiOperation(value = "根据业务单id作废未开具的发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/abandonUnissuedInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response abandonUnissuedInvoice(@RequestBody AbandonUnissuedRequest abandonUnissuedRequest);

    @ApiOperation(value = "根据业务单id查询拆票结果", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/countPreBillByBillId",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response countPreBillByBillId(@RequestBody BillInfo billInfo);

    @ApiOperation(value = "根据票面抬头信息和业务单id更新预制发票票面抬头", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/updatePreInvoiceByTtitle",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updatePreInvoiceByTtitle(@RequestBody PreInvoiceTtitleRequest preInvoiceTtitleRequest );

    @ApiOperation(value = "根据票面人信息和业务单id更新预制发票票面人", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/updatePreInvoiceByOperator",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updatePreInvoiceByOperator(@RequestBody PreInvoiceOperatorRequest preInvoiceOperatorRequest);

    @ApiOperation(value = "根据公司信息和业务单id更新预制发票公司名称", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/updatePreInvoiceByCompanyName",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updatePreInvoiceByCompanyName(@RequestBody PreInvoiceCompanyNameRequest preInvoiceCompanyNameRequest);
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/ApplyRedNoByBatch",
            produces = {"application/json"},
            method = RequestMethod.POST)
    public Response applyRedNoByBatch(@RequestParam("batchNo") Long batchNo);


    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/applyRedNoByPreInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    public Response applyRedNoByPreInvoice(@RequestBody List<Long> preInvoiceIds);


    @ApiOperation(value = "检验或者删除红字信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/validOrDelRedNotification",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response validOrDelRedNotification(@RequestBody ValidOrDelRedNotificationRequest validOrDelRedNotificationRequest);

    @ApiOperation(value = "作废或者删除预制发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/abandonOrDelPreInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response abandonOrDelPreInvoice(@RequestBody AbandonOrDelPreInvoiceRequest abandonOrDelPreInvoiceRequest);

    @ApiOperation(value = "作废业务单前检验预制发票状态", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/checkPreInvoiceBeforeDel",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response checkPreInvoiceBeforeDel(@RequestBody AbandonOrDelPreInvoiceRequest abandonOrDelPreInvoiceRequest);

    @ApiOperation(value = "根据批次号删除预制发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/delPreInvoiceByBatchNos",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response delPreInvoiceByBatchNos(@RequestBody List<Long> bathNoList);

    @ApiOperation(value = "根据批次号查询预制发票数量", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/queryPreInvoiceCountByBatchNos",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response queryPreInvoiceCountByBatchNos(@RequestBody List<Long> bathNoList);
}
