package com.xforceplus.seller.invoice.client.api;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.xforceplus.seller.invoice.client.model.MsMakeOutBeforeConfirmedRequest;
import com.xforceplus.seller.invoice.client.model.MsCancelSplitRequest;
import com.xforceplus.seller.invoice.client.model.MsCancelSplitResponse;
import com.xforceplus.seller.invoice.client.model.MsMakeOutBeforeConfirmedResponse;
import com.xforceplus.seller.invoice.client.model.MsPollingSplitAndMakeOutRequest;
import com.xforceplus.seller.invoice.client.model.MsPollingSplitAndMakeOutResponse;
import com.xforceplus.seller.invoice.client.model.MsSplitAndMakeOutRequest;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;

@Api(value = "splitAndMakeOutInvoice", description = "the splitAndMakeOutInvoice API")
public interface SplitAndMakeOutInvoiceApi {

    @ApiOperation(value = "拆票开票", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "SplitAndMakeOutInvoice", })
    @ApiResponses(value = { @ApiResponse(code = 200, message = "拆票开票异步结果", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/splitAndMakeOutInvoice/makeOut", produces = {
            "application/json" }, method = RequestMethod.POST)
    BaseAsyncResponse makeOut(
            @ApiParam(value = "开票参数", required = true) @RequestBody MsSplitAndMakeOutRequest splitAndMakeOutRequest);

    @ApiOperation(value = "拆票开票结果轮询", notes = "", response = MsPollingSplitAndMakeOutResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "SplitAndMakeOutInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "拆票开票轮询结果", response = MsPollingSplitAndMakeOutResponse.class) })
    @RequestMapping(value = "/splitAndMakeOutInvoice/pollingMakeOutResponse", produces = {
            "application/json" }, method = RequestMethod.POST)
    MsPollingSplitAndMakeOutResponse pollingMakeOutResponse(
            @ApiParam(value = "任务id", required = true) @RequestBody MsPollingSplitAndMakeOutRequest request);

    @ApiOperation(value = "取消拆票", notes = "", response = MsCancelSplitResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "SplitAndMakeOutInvoice", })
    @ApiResponses(value = { @ApiResponse(code = 200, message = "取消拆票结果", response = MsCancelSplitResponse.class) })
    @RequestMapping(value = "/splitAndMakeOutInvoice/cancelSplitByBatchNo", produces = {
            "application/json" }, method = RequestMethod.POST)
    MsCancelSplitResponse cancelSplitByBatchNo(
            @ApiParam(value = "批次号", required = true) @RequestBody MsCancelSplitRequest request);

    @ApiOperation(value = "通过批次号开具", notes = "", response = MsMakeOutBeforeConfirmedResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "SplitAndMakeOutInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通过批次号开具", response = MsMakeOutBeforeConfirmedResponse.class) })
    @RequestMapping(value = "/splitAndMakeOutInvoice/makeOutByBatchNo", produces = {
            "application/json" }, method = RequestMethod.POST)
    MsMakeOutBeforeConfirmedResponse makeOutByBatchNo(
            @ApiParam(value = "批次号", required = true) @RequestBody MsMakeOutBeforeConfirmedRequest request);
}
